/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram.plantuml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;
import org.asciidoctor.diagram.DiagramGeneratorFunction;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.MimeType;
import org.asciidoctor.diagram.MultipartWriter;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.ResponseData;

public class PlantUML
implements DiagramGeneratorFunction {
    public static final String X_GRAPHVIZ = "X-Graphviz";
    public static final String X_PLANT_UML_CONFIG = "X-PlantUML-Config";
    public static final String X_PLANT_UML_DEBUG = "X-PlantUML-Debug";
    public static final String X_PLANT_UML_SIZE_LIMIT = "X-PlantUML-SizeLimit";
    public static final String X_PLANT_UML_THEME = "X-PlantUML-Theme";
    private static final MimeType DEFAULT_OUTPUT_FORMAT;
    private static final int DEFAULT_IMAGE_SIZE_LIMIT = 4096;
    private static final String SMETANA = "smetana";
    private static final String ELK = "elk";
    private static Method SET_DOT_EXE;
    private static Object SET_DOT_EXE_INSTANCE;
    private static Method SET_LOCAL_IMAGE_LIMIT;
    private static Object SET_LOCAL_IMAGE_LIMIT_INSTANCE;
    private static Method REMOVE_LOCAL_LIMIT_SIZE;
    private static Object REMOVE_LOCAL_LIMIT_SIZE_INSTANCE;
    private static Method SET_USE_ELK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ResponseData generate(Request request) throws IOException {
        boolean debug;
        FileFormatOption fileFormat;
        File graphviz;
        String pathToGraphViz = request.headers.getValue(X_GRAPHVIZ);
        if (pathToGraphViz != null) {
            if (pathToGraphViz.equalsIgnoreCase(SMETANA)) {
                pathToGraphViz = SMETANA;
                graphviz = null;
            } else if (pathToGraphViz.equalsIgnoreCase(ELK)) {
                pathToGraphViz = ELK;
                graphviz = null;
            } else {
                File graphvizParam = new File(pathToGraphViz);
                if (!graphvizParam.canExecute()) throw new IOException("GraphViz 'dot' tool at '" + pathToGraphViz + "' is not executable");
                graphviz = graphvizParam;
            }
        } else {
            graphviz = null;
        }
        MimeType format = (MimeType)request.headers.getValue(HTTPHeader.ACCEPT);
        if (format == null) {
            format = DEFAULT_OUTPUT_FORMAT;
        }
        if (format.equals((Object)MimeType.PNG)) {
            fileFormat = new FileFormatOption(FileFormat.PNG);
        } else if (format.equals((Object)MimeType.SVG)) {
            fileFormat = new FileFormatOption(FileFormat.SVG);
        } else if (format.equals((Object)MimeType.TEXT_PLAIN_UTF8)) {
            fileFormat = new FileFormatOption(FileFormat.UTXT);
        } else {
            if (!format.equals((Object)MimeType.TEXT_PLAIN)) throw new IOException("Unsupported output format: " + format);
            fileFormat = new FileFormatOption(FileFormat.ATXT);
            format = MimeType.parse((String)(MimeType.TEXT_PLAIN + ";charset=" + Charset.defaultCharset().name().toLowerCase()));
        }
        Option option = new Option();
        String plantUmlConfig = request.headers.getValue(X_PLANT_UML_CONFIG);
        if (plantUmlConfig != null) {
            option.initConfig(plantUmlConfig);
        }
        boolean bl = debug = request.headers.getValue(X_PLANT_UML_DEBUG) != null;
        if (debug) {
            fileFormat.setDebugSvek(true);
            option.setDebugSvek(true);
        }
        option.setFileFormatOption(fileFormat);
        ArrayList<String> config = new ArrayList<String>(option.getConfig());
        String plantUmlTheme = request.headers.getValue(X_PLANT_UML_THEME);
        if (plantUmlTheme != null) {
            config.add(0, "!theme " + plantUmlTheme);
        }
        int sizeLimit = 4096;
        String sizeLimitHeader = request.headers.getValue(X_PLANT_UML_SIZE_LIMIT);
        if (sizeLimitHeader != null) {
            sizeLimit = Integer.parseInt(sizeLimitHeader);
        }
        byte[] responseData = new byte[]{};
        try {
            SET_LOCAL_IMAGE_LIMIT.invoke(SET_LOCAL_IMAGE_LIMIT_INSTANCE, sizeLimit);
            try {
                PlantUML plantUML = this;
                synchronized (plantUML) {
                    SET_DOT_EXE.invoke(SET_DOT_EXE_INSTANCE, graphviz != null ? graphviz.getAbsolutePath() : null);
                    SFile currentDir = FileSystem.getInstance().getCurrentDir();
                    BlockUmlBuilder builder = new BlockUmlBuilder(config, "UTF-8", Defines.createEmpty(), (Reader)new StringReader(request.asString()), currentDir, "<input>");
                    List blocks = builder.getBlockUmls();
                    if (blocks.isEmpty()) {
                        throw new IOException("No @startuml found");
                    }
                    for (BlockUml b : blocks) {
                        Diagram system = b.getDiagram();
                        if (system instanceof PSystemError) {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            system.exportDiagram((OutputStream)byteArrayOutputStream, 0, new FileFormatOption(FileFormat.UTXT));
                            String error = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                            throw new IOException(error);
                        }
                        if (SMETANA.equalsIgnoreCase(pathToGraphViz)) {
                            if (!(system instanceof TitledDiagram)) throw new IOException("Cannot use Smetana engine with diagram class " + system.getClass().getSimpleName());
                            ((TitledDiagram)system).setUseSmetana(true);
                        } else if (ELK.equalsIgnoreCase(pathToGraphViz)) {
                            if (!(system instanceof TitledDiagram)) throw new IOException("Cannot use Eclipse Layout Kernel (ELK) engine with diagram class " + system.getClass().getSimpleName());
                            if (SET_USE_ELK == null) throw new IOException("Eclipse Layout Kernel (ELK) support is not available");
                            SET_USE_ELK.invoke((Object)system, true);
                        }
                        if (system.getNbImages() <= 0) continue;
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        system.exportDiagram((OutputStream)byteArrayOutputStream, 0, fileFormat);
                        responseData = byteArrayOutputStream.toByteArray();
                        break;
                    }
                    if (!debug) return new ResponseData(format, responseData);
                    Path currentDirPath = currentDir.conv().toPath();
                    Path svekDotPath = currentDirPath.resolve("svek.dot");
                    boolean svekDotExists = Files.exists(svekDotPath, new LinkOption[0]);
                    Path svekSvgPath = currentDirPath.resolve("svek.svg");
                    boolean svekSvgExists = Files.exists(svekSvgPath, new LinkOption[0]);
                    if (!svekDotExists && !svekSvgExists) return new ResponseData(format, responseData);
                    MultipartWriter multipartWriter = new MultipartWriter();
                    multipartWriter.addPart("image", format, responseData);
                    if (svekDotExists) {
                        byte[] svekDot = Files.readAllBytes(svekDotPath);
                        Files.deleteIfExists(svekDotPath);
                        multipartWriter.addPart("svekdot", MimeType.TEXT_PLAIN_UTF8, svekDot);
                    }
                    if (svekSvgExists) {
                        byte[] svekSvg = Files.readAllBytes(svekSvgPath);
                        Files.deleteIfExists(svekSvgPath);
                        multipartWriter.addPart("sveksvg", MimeType.SVG, svekSvg);
                    }
                    format = multipartWriter.getFormat();
                    responseData = multipartWriter.finish();
                    return new ResponseData(format, responseData);
                }
            }
            finally {
                REMOVE_LOCAL_LIMIT_SIZE.invoke(REMOVE_LOCAL_LIMIT_SIZE_INSTANCE, new Object[0]);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    static {
        Class<?> utils2;
        DEFAULT_OUTPUT_FORMAT = MimeType.PNG;
        ClassLoader classLoader = PlantUML.class.getClassLoader();
        try {
            Class<?> optionFlags = classLoader.loadClass("net.sourceforge.plantuml.OptionFlags");
            SET_DOT_EXE = optionFlags.getMethod("setDotExecutable", String.class);
            SET_DOT_EXE_INSTANCE = optionFlags.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException | RuntimeException optionFlags) {
            // empty catch block
        }
        try {
            utils2 = classLoader.loadClass("net.sourceforge.plantuml.dot.GraphvizUtils");
            SET_DOT_EXE = utils2.getMethod("setDotExecutable", String.class);
            SET_DOT_EXE_INSTANCE = null;
            SET_LOCAL_IMAGE_LIMIT = utils2.getMethod("setLocalImageLimit", Integer.TYPE);
            SET_LOCAL_IMAGE_LIMIT_INSTANCE = null;
            REMOVE_LOCAL_LIMIT_SIZE = utils2.getMethod("removeLocalLimitSize", new Class[0]);
            REMOVE_LOCAL_LIMIT_SIZE_INSTANCE = null;
        }
        catch (ReflectiveOperationException | RuntimeException utils2) {
            // empty catch block
        }
        try {
            utils2 = classLoader.loadClass("net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils");
            SET_DOT_EXE = utils2.getMethod("setDotExecutable", String.class);
            SET_DOT_EXE_INSTANCE = null;
            SET_LOCAL_IMAGE_LIMIT = utils2.getMethod("setLocalImageLimit", Integer.TYPE);
            SET_LOCAL_IMAGE_LIMIT_INSTANCE = null;
            REMOVE_LOCAL_LIMIT_SIZE = utils2.getMethod("removeLocalLimitSize", new Class[0]);
            REMOVE_LOCAL_LIMIT_SIZE_INSTANCE = null;
        }
        catch (ReflectiveOperationException | RuntimeException utils3) {
            // empty catch block
        }
        if (SET_DOT_EXE == null) {
            throw new IllegalStateException("Could not find setDotExecutable method");
        }
        try {
            Class<TitledDiagram> titledDiagram = TitledDiagram.class;
            SET_USE_ELK = titledDiagram.getMethod("setUseElk", Boolean.TYPE);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            SET_USE_ELK = null;
        }
    }
}

