/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.asciidoctor.diagram.Charsets;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.HTTPHeaders;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.RequestOutput;
import org.asciidoctor.diagram.Response;
import org.asciidoctor.diagram.ResponseOutput;

class HTTPOutputStream
extends FilterOutputStream
implements ResponseOutput,
RequestOutput {
    private static final byte[] HTML_VERSION = "HTTP/1.1".getBytes(Charsets.US_ASCII);

    public HTTPOutputStream(OutputStream out) {
        super(new BufferedOutputStream(out));
    }

    public void write(String string) throws IOException {
        this.out.write(string.getBytes(Charsets.US_ASCII));
    }

    public void writeStatusLine(int code, String reason) throws IOException {
        this.out.write(HTML_VERSION);
        this.out.write(32);
        this.write(Integer.toString(code));
        this.out.write(32);
        this.write(reason);
        this.newline();
    }

    public void writeRequestLine(String method, URI requestURI) throws IOException {
        this.write(method);
        this.out.write(32);
        this.write(requestURI.toString());
        this.out.write(32);
        this.out.write(HTML_VERSION);
        this.newline();
    }

    public void writeHeader(String key, String value) throws IOException {
        this.write(key);
        this.write(": ");
        this.write(value);
        this.newline();
    }

    public void newline() throws IOException {
        this.out.write(13);
        this.out.write(10);
    }

    @Override
    public void writeResponse(Response response) throws IOException {
        this.writeStatusLine(response.code, response.reason);
        this.writeHeaders(response.headers);
        if (response.headers.getValue(HTTPHeader.CONTENT_LENGTH.name) == null && response.data != null) {
            this.writeHeader(HTTPHeader.CONTENT_LENGTH.name, Integer.toString(response.data.length));
        }
        this.newline();
        if (response.data != null) {
            this.out.write(response.data);
        }
        this.out.flush();
    }

    @Override
    public void writeRequest(Request request) throws IOException {
        this.writeRequestLine("GET", request.requestUri);
        this.writeHeaders(request.headers);
        if (request.headers.getValue(HTTPHeader.CONTENT_LENGTH.name) == null && request.data != null) {
            this.writeHeader(HTTPHeader.CONTENT_LENGTH.name, Integer.toString(request.data.length));
        }
        this.newline();
        if (request.data != null) {
            this.out.write(request.data);
        }
        this.out.flush();
    }

    private void writeHeaders(HTTPHeaders headers) throws IOException {
        for (String key : headers.keys()) {
            this.writeHeader(key, headers.getValue(key));
        }
    }
}

