#    CMake module to find libdockapp
#    Copyright (C) 2017  Andreas Tscharner <andy@vis.ethz.ch>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

find_path(
    DOCKAPP_INCLUDE_DIR
    NAMES libdockapp/dockapp.h
    PATHS /usr/local/include
          /usr/include
)

find_library(
    DOCKAPP_LIBRARY
    NAMES dockapp
    PATHS /usr/local/lib
          /usr/local/lib64
          /usr/lib
          /usr/lib64
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(DOCKAPP DEFAULT_MSG DOCKAPP_LIBRARY DOCKAPP_INCLUDE_DIR)
mark_as_advanced(DOCKAPP_LIBRARY DOCKAPP_INCLUDE_DIR)
