/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;

public class OperationListener
implements BuildOperationListener {
    private final ThreadLocal<Map<OperationIdentifier, Object>> runningOps = ThreadLocal.withInitial(HashMap::new);
    static final Object NO_DETAILS = new Object();

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        Object details = buildOperation.getDetails();
        if (details == null) {
            details = NO_DETAILS;
        }
        this.runningOps.get().put(this.mandatoryIdOf(buildOperation), details);
    }

    public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        this.runningOps.get().remove(this.mandatoryIdOf(buildOperation));
    }

    private OperationIdentifier mandatoryIdOf(BuildOperationDescriptor buildOperation) {
        OperationIdentifier id = buildOperation.getId();
        if (id == null) {
            throw new IllegalStateException(String.format("Build operation %s has no valid id", buildOperation));
        }
        return id;
    }

    @Nullable
    public <T> T getOp(OperationIdentifier id, Class<T> targetClass) {
        Object op = this.runningOps.get().get(id);
        return targetClass.isInstance(op) ? (T)targetClass.cast(op) : null;
    }
}

