/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.tracker.internal;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value=Scopes.Build.class)
public class PluginVersionTracker {
    final Map<ClassLoaderScope, Map<String, String>> pluginVersionsPerScope = new ConcurrentHashMap<ClassLoaderScope, Map<String, String>>();

    public void setPluginVersionAt(ClassLoaderScope scope, String pluginId, String pluginVersion) {
        Map pluginVersions = this.pluginVersionsPerScope.computeIfAbsent(scope.getOriginalScope(), ignored -> new ConcurrentHashMap());
        if (pluginVersions.containsKey(pluginId)) {
            throw new IllegalStateException("Plugin version already set for " + pluginId);
        }
        pluginVersions.put(pluginId, pluginVersion);
    }

    @Nullable
    public String findPluginVersionAt(ClassLoaderScope scope, String pluginId) {
        while (scope != null) {
            String pluginVersion = (String)this.pluginVersionsPerScope.getOrDefault(scope.getOriginalScope(), Collections.emptyMap()).get(pluginId);
            if (pluginVersion != null) {
                return pluginVersion;
            }
            ClassLoaderScope parent = scope.getParent();
            if (scope == parent) break;
            scope = parent;
        }
        return null;
    }
}

