/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.security.KeyStore;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.configurationcache.DefaultConfigurationCacheKt;
import org.gradle.configurationcache.KeyStoreKeySource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/gradle/configurationcache/KeyStoreKeySource;", "", "encryptionAlgorithm", "", "customKeyStoreDir", "Ljava/io/File;", "keyAlias", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/String;)V", "getCustomKeyStoreDir", "()Ljava/io/File;", "getEncryptionAlgorithm", "()Ljava/lang/String;", "getKeyAlias", "keyProtection", "Ljava/security/KeyStore$PasswordProtection;", "keyStore", "Ljava/security/KeyStore;", "kotlin.jvm.PlatformType", "getKeyStore", "()Ljava/security/KeyStore;", "keyStore$delegate", "Lkotlin/Lazy;", "sourceDescription", "getSourceDescription", "createKeyStoreAndGenerateKey", "Ljavax/crypto/SecretKey;", "keyStoreFile", "generateKey", "alias", "loadSecretKeyFromExistingKeystore", "Companion", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nEncryptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionService.kt\norg/gradle/configurationcache/KeyStoreKeySource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class KeyStoreKeySource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String encryptionAlgorithm;
    @Nullable
    private final File customKeyStoreDir;
    @NotNull
    private final String keyAlias;
    @NotNull
    private final KeyStore.PasswordProtection keyProtection;
    @NotNull
    private final Lazy keyStore$delegate;
    @NotNull
    public static final String KEYSTORE_TYPE = "pkcs12";
    @NotNull
    private static final char[] KEYSTORE_PASSWORD;

    public KeyStoreKeySource(@NotNull String encryptionAlgorithm2, @Nullable File customKeyStoreDir, @NotNull String keyAlias) {
        Intrinsics.checkNotNullParameter((Object)encryptionAlgorithm2, (String)"encryptionAlgorithm");
        Intrinsics.checkNotNullParameter((Object)keyAlias, (String)"keyAlias");
        this.encryptionAlgorithm = encryptionAlgorithm2;
        this.customKeyStoreDir = customKeyStoreDir;
        this.keyAlias = keyAlias;
        this.keyProtection = new KeyStore.PasswordProtection(new char[0]);
        this.keyStore$delegate = LazyKt.lazy((Function0)keyStore.2.INSTANCE);
    }

    @NotNull
    public final String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Nullable
    public final File getCustomKeyStoreDir() {
        return this.customKeyStoreDir;
    }

    @NotNull
    public final String getKeyAlias() {
        return this.keyAlias;
    }

    private final KeyStore getKeyStore() {
        Lazy lazy = this.keyStore$delegate;
        return (KeyStore)lazy.getValue();
    }

    @NotNull
    public final String getSourceDescription() {
        Object object;
        block3: {
            block2: {
                object = this.customKeyStoreDir;
                if (object == null) break block2;
                File it = object;
                boolean bl = false;
                String string2 = "custom Java keystore at " + it;
                object = string2;
                if (string2 != null) break block3;
            }
            object = "default Gradle configuration cache keystore";
        }
        return object;
    }

    @NotNull
    public final SecretKey createKeyStoreAndGenerateKey(@NotNull File keyStoreFile) {
        SecretKey secretKey2;
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        DefaultConfigurationCacheKt.getLogger().debug("No keystore found");
        this.getKeyStore().load(null, KEYSTORE_PASSWORD);
        SecretKey it = secretKey2 = this.generateKey(keyStoreFile, this.keyAlias);
        boolean bl = false;
        DefaultConfigurationCacheKt.getLogger().debug("Key added to a new keystore at {}", (Object)keyStoreFile);
        return secretKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SecretKey loadSecretKeyFromExistingKeystore(@NotNull File keyStoreFile) {
        Intrinsics.checkNotNullParameter((Object)keyStoreFile, (String)"keyStoreFile");
        DefaultConfigurationCacheKt.getLogger().debug("Loading keystore from {}", (Object)keyStoreFile);
        Closeable closeable = new FileInputStream(keyStoreFile);
        Serializable serializable = null;
        try {
            Object fis = (FileInputStream)closeable;
            boolean bl = false;
            this.getKeyStore().load((InputStream)fis, KEYSTORE_PASSWORD);
            fis = Unit.INSTANCE;
        }
        catch (Throwable fis) {
            serializable = fis;
            throw fis;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)serializable);
        }
        KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)this.getKeyStore().getEntry(this.keyAlias, this.keyProtection);
        if (entry != null) {
            Object it = fis = entry.getSecretKey();
            boolean bl = false;
            DefaultConfigurationCacheKt.getLogger().debug("Retrieved key");
            Object object = fis;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entry.secretKey.also {\n \u2026ieved key\")\n            }");
            return object;
        }
        DefaultConfigurationCacheKt.getLogger().debug("No key found");
        Serializable it = serializable = this.generateKey(keyStoreFile, this.keyAlias);
        boolean bl = false;
        DefaultConfigurationCacheKt.getLogger().warn("Key added to existing keystore at {}", (Object)keyStoreFile);
        return serializable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecretKey generateKey(File keyStoreFile, String alias) {
        SecretKey newKey = KeyGenerator.getInstance(this.encryptionAlgorithm).generateKey();
        if (!(newKey != null)) {
            boolean bl = false;
            String string2 = "Failed to generate encryption key using " + this.encryptionAlgorithm + '.';
            throw new IllegalArgumentException(string2.toString());
        }
        DefaultConfigurationCacheKt.getLogger().debug("Generated key");
        KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(newKey);
        this.getKeyStore().setEntry(alias, entry, this.keyProtection);
        Closeable closeable = new FileOutputStream(keyStoreFile);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            this.getKeyStore().store(fos, KEYSTORE_PASSWORD);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)newKey, (String)"newKey");
        return newKey;
    }

    static {
        char[] cArray = new char[]{'c', 'c'};
        KEYSTORE_PASSWORD = cArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/gradle/configurationcache/KeyStoreKeySource$Companion;", "", "()V", "KEYSTORE_PASSWORD", "", "getKEYSTORE_PASSWORD", "()[C", "KEYSTORE_TYPE", "", "configuration-cache"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final char[] getKEYSTORE_PASSWORD() {
            return KEYSTORE_PASSWORD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

