/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// LifecycleHandlerApplyConfiguration represents a declarative configuration of the LifecycleHandler type for use
// with apply.
//
// LifecycleHandler defines a specific action that should be taken in a lifecycle
// hook. One and only one of the fields, except TCPSocket must be specified.
type LifecycleHandlerApplyConfiguration struct {
	// Exec specifies a command to execute in the container.
	Exec *ExecActionApplyConfiguration `json:"exec,omitempty"`
	// HTTPGet specifies an HTTP GET request to perform.
	HTTPGet *HTTPGetActionApplyConfiguration `json:"httpGet,omitempty"`
	// Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept
	// for backward compatibility. There is no validation of this field and
	// lifecycle hooks will fail at runtime when it is specified.
	TCPSocket *TCPSocketActionApplyConfiguration `json:"tcpSocket,omitempty"`
	// Sleep represents a duration that the container should sleep.
	Sleep *SleepActionApplyConfiguration `json:"sleep,omitempty"`
}

// LifecycleHandlerApplyConfiguration constructs a declarative configuration of the LifecycleHandler type for use with
// apply.
func LifecycleHandler() *LifecycleHandlerApplyConfiguration {
	return &LifecycleHandlerApplyConfiguration{}
}

// WithExec sets the Exec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Exec field is set to the value of the last call.
func (b *LifecycleHandlerApplyConfiguration) WithExec(value *ExecActionApplyConfiguration) *LifecycleHandlerApplyConfiguration {
	b.Exec = value
	return b
}

// WithHTTPGet sets the HTTPGet field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HTTPGet field is set to the value of the last call.
func (b *LifecycleHandlerApplyConfiguration) WithHTTPGet(value *HTTPGetActionApplyConfiguration) *LifecycleHandlerApplyConfiguration {
	b.HTTPGet = value
	return b
}

// WithTCPSocket sets the TCPSocket field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TCPSocket field is set to the value of the last call.
func (b *LifecycleHandlerApplyConfiguration) WithTCPSocket(value *TCPSocketActionApplyConfiguration) *LifecycleHandlerApplyConfiguration {
	b.TCPSocket = value
	return b
}

// WithSleep sets the Sleep field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Sleep field is set to the value of the last call.
func (b *LifecycleHandlerApplyConfiguration) WithSleep(value *SleepActionApplyConfiguration) *LifecycleHandlerApplyConfiguration {
	b.Sleep = value
	return b
}
