/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sbt.AttributeKey;
import sbt.Highlight$;
import sbt.IO$;
import sbt.State;
import sbt.State$;
import sbt.complete.DefaultParsers$;
import sbt.complete.Parser;
import sbt.complete.RichParser;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class CommandUtil$ {
    public static final CommandUtil$ MODULE$;
    private final int HelpPatternFlags;

    static {
        new CommandUtil$();
    }

    public Seq<String> readLines(Seq<File> files) {
        return (Seq)((TraversableLike)files.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(File line) {
                return IO$.MODULE$.readLines(line, IO$.MODULE$.readLines$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(String s) {
                return Option$.MODULE$.option2Iterable(CommandUtil$.MODULE$.processLine(s));
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> processLine(String s) {
        String trimmed = s.trim();
        return this.ignoreLine(trimmed) ? None$.MODULE$ : new Some((Object)trimmed);
    }

    public boolean ignoreLine(String s) {
        return s.isEmpty() || s.startsWith("#");
    }

    private Function1<File, Object> canRead() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.canRead();
            }
        };
    }

    public Seq<File> notReadable(Seq<File> files) {
        return (Seq)files.filterNot(this.canRead());
    }

    public Seq<File> readable(Seq<File> files) {
        return (Seq)files.filter(this.canRead());
    }

    public File bootDirectory(State state) {
        File file;
        try {
            file = state.configuration().provider().scalaProvider().launcher().bootDirectory();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            file = new File(".").getAbsoluteFile();
        }
        return file;
    }

    public Seq<String> aligned(String pre, String sep, Seq<Tuple2<String, String>> in) {
        Nil$ nil$;
        if (in.isEmpty()) {
            nil$ = Nil$.MODULE$;
        } else {
            int width = BoxesRunTime.unboxToInt((Object)((TraversableOnce)in.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String, String> x$2) {
                    return ((String)x$2._1()).length();
                }
            }, Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            nil$ = (Seq)in.map((Function1)new Serializable(pre, sep, width){
                public static final long serialVersionUID = 0L;
                private final String pre$1;
                private final String sep$1;
                private final int width$1;

                public final String apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String a = (String)tuple2._1();
                        String b = (String)tuple2._2();
                        String string = new StringBuilder().append((Object)this.pre$1).append((Object)CommandUtil$.MODULE$.fill(a, this.width$1)).append((Object)this.sep$1).append((Object)b).toString();
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.pre$1 = pre$1;
                    this.sep$1 = sep$1;
                    this.width$1 = width$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return nil$;
    }

    public String fill(String s, int size) {
        return new StringBuilder().append((Object)s).append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(package$.MODULE$.max(size - s.length(), 0))).toString();
    }

    public <T> State withAttribute(State s, AttributeKey<T> key, String ifMissing, Function1<T, State> f) {
        Option<T> option;
        block4: {
            State state;
            block3: {
                block2: {
                    option = State$.MODULE$.stateOps(s).get(key);
                    None$ none$ = None$.MODULE$;
                    Option<T> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    State$.MODULE$.stateOps(s).log().error((Function0)new Serializable(ifMissing){
                        public static final long serialVersionUID = 0L;
                        private final String ifMissing$1;

                        public final String apply() {
                            return this.ifMissing$1;
                        }
                        {
                            this.ifMissing$1 = ifMissing$1;
                        }
                    });
                    state = State$.MODULE$.stateOps(s).fail();
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Object nav = some.x();
                state = (State)f.apply(nav);
            }
            return state;
        }
        throw new MatchError(option);
    }

    public Parser<String> singleArgument(Set<String> exampleStrings) {
        Parser arg = DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.NotSpaceClass()).$tilde(DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.any()).$times())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<Object, Seq<Object>> x0$2) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    char ns = tuple2._1$mcC$sp();
                    Seq s = (Seq)tuple2._2();
                    char c = ns;
                    String string = ((TraversableOnce)s.$plus$colon((Object)BoxesRunTime.boxToCharacter((char)c), Seq$.MODULE$.canBuildFrom())).mkString();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        });
        RichParser qual$1 = DefaultParsers$.MODULE$.richParser(arg);
        Set<String> x$5 = exampleStrings;
        boolean x$6 = qual$1.examples$default$2();
        return DefaultParsers$.MODULE$.richParser(DefaultParsers$.MODULE$.token(DefaultParsers$.MODULE$.Space())).$tilde$greater(DefaultParsers$.MODULE$.token(qual$1.examples(x$5, x$6)));
    }

    public String detail(String selected, Map<String, String> detailMap) {
        Option option;
        block6: {
            String string;
            block5: {
                block4: {
                    String exactDetail;
                    option = detailMap.get((Object)selected);
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    string = exactDetail = (String)some.x();
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                try {
                    Map<String, String> details = this.searchHelp(selected, detailMap);
                    string = details.isEmpty() ? new StringBuilder().append((Object)"No matches for regular expression '").append((Object)selected).append((Object)"'.").toString() : this.layoutDetails(details);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Invalid regular expression (java.util.regex syntax).\n").append((Object)patternSyntaxException.getMessage()).toString());
                }
            }
            return string;
        }
        throw new MatchError((Object)option);
    }

    public Map<String, String> searchHelp(String selected, Map<String, String> detailMap) {
        Pattern pattern = Pattern.compile(selected, 66);
        return (Map)detailMap.flatMap((Function1)new Serializable(pattern){
            public static final long serialVersionUID = 0L;
            private final Pattern pattern$1;

            public final List<Tuple2<String, String>> apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    Nil$ nil$;
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Option<String> contentMatches = Highlight$.MODULE$.showMatches(this.pattern$1, v);
                    Option<String> keyMatches = Highlight$.MODULE$.showMatches(this.pattern$1, k);
                    String keyString = Highlight$.MODULE$.bold((String)keyMatches.getOrElse((Function0)new Serializable(this, k){
                        public static final long serialVersionUID = 0L;
                        private final String k$1;

                        public final String apply() {
                            return this.k$1;
                        }
                        {
                            this.k$1 = k$1;
                        }
                    }));
                    String contentString = (String)contentMatches.getOrElse((Function0)new Serializable(this, v){
                        public static final long serialVersionUID = 0L;
                        private final String v$1;

                        public final String apply() {
                            return this.v$1;
                        }
                        {
                            this.v$1 = v$1;
                        }
                    });
                    if (keyMatches.isDefined() || contentMatches.isDefined()) {
                        Tuple2 tuple22 = new Tuple2((Object)keyString, (Object)contentString);
                        nil$ = Nil$.MODULE$.$colon$colon((Object)tuple22);
                    } else {
                        nil$ = Nil$.MODULE$;
                    }
                    Nil$ nil$2 = nil$;
                    return nil$2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pattern$1 = pattern$1;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public String layoutDetails(Map<String, String> details) {
        return ((TraversableOnce)details.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringBuilder().append((Object)k).append((Object)"\n\n  ").append((Object)v).toString();
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n", "\n\n", "\n");
    }

    public final int HelpPatternFlags() {
        return 66;
    }

    private CommandUtil$() {
        MODULE$ = this;
    }
}

