/*
 * Decompiled with CFR 0.152.
 */
package com.elovirta.dita.html;

import com.elovirta.dita.markdown.MarkdownReader;
import com.elovirta.dita.utils.ClasspathURIResolver;
import com.google.common.collect.Lists;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataSet;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.sax.HtmlParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class HtmlReader
implements XMLReader {
    private final HtmlParser parser = new HtmlParser();
    private final SAXResult result;

    public HtmlReader(DataSet options, String ... stylesheets) {
        this.parser.setDoctypeExpectation(DoctypeExpectation.AUTO);
        this.parser.setHeuristics(Heuristics.ICU);
        try {
            SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
            tf.setURIResolver(new ClasspathURIResolver(tf.getURIResolver()));
            TransformerHandler transformerHandler = null;
            SAXResult res = this.result = new SAXResult();
            for (String stylesheet : Lists.reverse(Arrays.asList(stylesheets))) {
                StreamSource src = new StreamSource(this.getClass().getResourceAsStream("/" + stylesheet), "classpath:///" + stylesheet);
                transformerHandler = tf.newTransformerHandler(src);
                transformerHandler.getTransformer().setParameter("formats", String.join((CharSequence)",", (Iterable)MarkdownReader.FORMATS.get((DataHolder)options)));
                transformerHandler.setResult(res);
                res = new SAXResult(transformerHandler);
            }
            this.parser.setContentHandler(transformerHandler);
            this.parser.setLexicalHandler(transformerHandler);
            this.parser.setDTDHandler(transformerHandler);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parser.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setFeature(name, value);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.parser.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setProperty(name, value);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.parser.setEntityResolver((publicId, systemId) -> {
            InputSource in = resolver.resolveEntity(publicId, systemId);
            if (in != null) {
                return in;
            }
            return new InputSource(systemId);
        });
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.parser.getEntityResolver();
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.parser.setDTDHandler(handler);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.parser.getDTDHandler();
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.result.setHandler(handler);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.result.getHandler();
    }

    @Override
    public void setErrorHandler(final ErrorHandler handler) {
        this.parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException e) throws SAXException {
                if (e instanceof SAXParseException && e.getMessage().equals("The character encoding of the document was not declared.")) {
                    return;
                }
                handler.warning(e);
            }

            @Override
            public void error(SAXParseException e) throws SAXException {
                handler.error(e);
            }

            @Override
            public void fatalError(SAXParseException e) throws SAXException {
                handler.fatalError(e);
            }
        });
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.parser.getErrorHandler();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.parser.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parser.parse(systemId);
    }
}

