/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.str.WhitespaceString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

public class CharacterMap {
    private StructuredQName name;
    private final IntHashMap<String> charMap;
    private int min = Integer.MAX_VALUE;
    private int max = 0;
    private boolean mapsWhitespace = false;

    public CharacterMap(StructuredQName name, IntHashMap<String> map) {
        this.name = name;
        this.charMap = map;
        this.init();
    }

    public CharacterMap(Iterable<CharacterMap> list) {
        this.charMap = new IntHashMap(64);
        for (CharacterMap map : list) {
            IntIterator keys = map.charMap.keyIterator();
            while (keys.hasNext()) {
                int next = keys.next();
                this.charMap.put(next, map.charMap.get(next));
            }
        }
        this.init();
    }

    private void init() {
        IntIterator keys = this.charMap.keyIterator();
        while (keys.hasNext()) {
            int next = keys.next();
            if (next < this.min) {
                this.min = next;
            }
            if (next > this.max) {
                this.max = next;
            }
            if (this.mapsWhitespace || !Whitespace.isWhite(next)) continue;
            this.mapsWhitespace = true;
        }
        if (this.min > 55296) {
            this.min = 55296;
        }
    }

    public StructuredQName getName() {
        return this.name;
    }

    public IntHashMap<String> getMap() {
        return this.charMap;
    }

    public UnicodeString map(UnicodeString in, boolean insertNulls) {
        boolean move;
        if (!this.mapsWhitespace && in instanceof WhitespaceString) {
            return in;
        }
        boolean bl = move = in.indexWhere(c -> c >= this.min && c <= this.max, 0L) >= 0L;
        if (!move) {
            return in;
        }
        UnicodeBuilder buffer = new UnicodeBuilder();
        IntIterator iter = in.codePoints();
        while (iter.hasNext()) {
            int c2 = iter.next();
            if (c2 >= this.min && c2 <= this.max) {
                String rep = this.charMap.get(c2);
                if (rep == null) {
                    buffer.append(c2);
                    continue;
                }
                if (insertNulls) {
                    buffer.append('\u0000');
                    buffer.append(rep);
                    buffer.append('\u0000');
                    continue;
                }
                buffer.append(rep);
                continue;
            }
            buffer.append(c2);
        }
        return buffer.toUnicodeString();
    }

    public void export(ExpressionPresenter out) {
        out.startElement("charMap");
        out.emitAttribute("name", this.name);
        IntIterator iter = this.charMap.keyIterator();
        while (iter.hasNext()) {
            int c = iter.next();
            String s = this.charMap.get(c);
            out.startElement("m");
            out.emitAttribute("c", c + "");
            out.emitAttribute("s", s);
            out.endElement();
        }
        out.endElement();
    }
}

