/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.Sets;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultGroovySourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.DefaultJavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.GroovyRuntime;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.api.tasks.javadoc.GroovydocAccess;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public abstract class GroovyBasePlugin
implements Plugin<Project> {
    public static final String GROOVY_RUNTIME_EXTENSION_NAME = "groovyRuntime";
    private final ObjectFactory objectFactory;
    private final ModuleRegistry moduleRegistry;
    private final JvmLanguageUtilities jvmLanguageUtils;

    @Inject
    public GroovyBasePlugin(ObjectFactory objectFactory, ModuleRegistry moduleRegistry, JvmLanguageUtilities jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.moduleRegistry = moduleRegistry;
        this.jvmLanguageUtils = jvmPluginServices;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        GroovyRuntime groovyRuntime = (GroovyRuntime)project.getExtensions().create(GROOVY_RUNTIME_EXTENSION_NAME, GroovyRuntime.class, new Object[]{project});
        this.configureCompileDefaults(project, groovyRuntime);
        this.configureSourceSetDefaults(project);
        this.configureGroovydoc(project, groovyRuntime);
    }

    private void configureCompileDefaults(Project project, GroovyRuntime groovyRuntime) {
        project.getTasks().withType(GroovyCompile.class).configureEach(compile -> {
            compile.getConventionMapping().map("groovyClasspath", () -> groovyRuntime.inferGroovyClasspath((Iterable<File>)compile.getClasspath()));
            DefaultJavaPluginExtension javaExtension = (DefaultJavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            JvmPluginsHelper.configureCompileDefaults((AbstractCompile)compile, (DefaultJavaPluginExtension)javaExtension, (rawConvention, javaVersionSupplier) -> {
                if (rawConvention != null) {
                    return rawConvention;
                }
                return JavaVersion.toVersion((Object)((JavaLauncher)compile.getJavaLauncher().get()).getMetadata().getLanguageVersion().toString());
            });
        });
    }

    private void configureSourceSetDefaults(Project project) {
        GroovyBasePlugin.javaPluginExtension(project).getSourceSets().all(sourceSet -> {
            GroovySourceDirectorySet groovySource = this.getGroovySourceDirectorySet((SourceSet)sourceSet);
            sourceSet.getExtensions().add(GroovySourceDirectorySet.class, "groovy", (Object)groovySource);
            groovySource.srcDir("src/" + sourceSet.getName() + "/groovy");
            GroovySourceDirectorySet groovySourceFiles = groovySource;
            sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(arg_0 -> GroovyBasePlugin.lambda$configureSourceSetDefaults$11f1eb8f$1((FileCollection)groovySourceFiles, arg_0)));
            sourceSet.getAllJava().source((SourceDirectorySet)groovySource);
            sourceSet.getAllSource().source((SourceDirectorySet)groovySource);
            TaskProvider<GroovyCompile> compileTask = this.createGroovyCompileTask(project, (SourceSet)sourceSet, groovySource);
            ConfigurationContainer configurations = project.getConfigurations();
            GroovyBasePlugin.configureLibraryElements(sourceSet, configurations, project.getObjects());
            this.configureTargetPlatform(compileTask, (SourceSet)sourceSet, configurations);
        });
    }

    private GroovySourceDirectorySet getGroovySourceDirectorySet(SourceSet sourceSet) {
        DefaultGroovySourceSet groovySourceSet = (DefaultGroovySourceSet)this.objectFactory.newInstance(DefaultGroovySourceSet.class, new Object[]{"groovy", ((DefaultSourceSet)sourceSet).getDisplayName(), this.objectFactory});
        DeprecationLogger.whileDisabled(() -> new DslObject((Object)sourceSet).getConvention().getPlugins().put("groovy", groovySourceSet));
        return groovySourceSet.getGroovy();
    }

    private static void configureLibraryElements(SourceSet sourceSet, ConfigurationContainer configurations, ObjectFactory objectFactory) {
        configurations.getByName(sourceSet.getCompileClasspathConfigurationName()).attributes(attrs -> attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, "classes+resources"))));
    }

    private void configureTargetPlatform(TaskProvider<GroovyCompile> compileTask, SourceSet sourceSet, ConfigurationContainer configurations) {
        this.jvmLanguageUtils.useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getCompileClasspathConfigurationName()), compileTask);
        this.jvmLanguageUtils.useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()), compileTask);
    }

    private TaskProvider<GroovyCompile> createGroovyCompileTask(Project project, SourceSet sourceSet, GroovySourceDirectorySet groovySource) {
        TaskProvider compileTask = project.getTasks().register(sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, groovyCompile -> {
            JvmPluginsHelper.compileAgainstJavaOutputs((AbstractCompile)groovyCompile, (SourceSet)sourceSet, (ObjectFactory)this.objectFactory);
            JvmPluginsHelper.configureAnnotationProcessorPath((SourceSet)sourceSet, (SourceDirectorySet)groovySource, (CompileOptions)groovyCompile.getOptions(), (Project)project);
            groovyCompile.setDescription("Compiles the " + groovySource + ".");
            groovyCompile.setSource((FileTree)groovySource);
            groovyCompile.getJavaLauncher().convention(GroovyBasePlugin.getJavaLauncher(project));
            groovyCompile.getGroovyOptions().getDisabledGlobalASTTransformations().convention((Iterable)Sets.newHashSet((Object[])new String[]{"groovy.grape.GrabAnnotationTransformation"}));
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet((SourceSet)sourceSet, (SourceDirectorySet)groovySource, (Project)project, (TaskProvider)compileTask, (Provider)compileTask.map(GroovyCompile::getOptions));
        project.getTasks().named(sourceSet.getClassesTaskName(), task -> task.dependsOn(new Object[]{compileTask}));
        return compileTask;
    }

    private void configureGroovydoc(Project project, GroovyRuntime groovyRuntime) {
        project.getTasks().withType(Groovydoc.class).configureEach(groovydoc -> {
            groovydoc.getConventionMapping().map("groovyClasspath", () -> {
                FileCollection groovyClasspath = groovyRuntime.inferGroovyClasspath((Iterable<File>)groovydoc.getClasspath());
                ConfigurableFileCollection jansi = project.getObjects().fileCollection().from(new Object[]{this.moduleRegistry.getExternalModule("jansi").getImplementationClasspath().getAsFiles()});
                return groovyClasspath.plus((FileCollection)jansi);
            });
            groovydoc.getConventionMapping().map("destinationDir", () -> ((Directory)GroovyBasePlugin.javaPluginExtension(project).getDocsDir().dir("groovydoc").get()).getAsFile());
            groovydoc.getConventionMapping().map("docTitle", () -> GroovyBasePlugin.extensionOf((ExtensionAware)project, ReportingExtension.class).getApiDocTitle());
            groovydoc.getConventionMapping().map("windowTitle", () -> GroovyBasePlugin.extensionOf((ExtensionAware)project, ReportingExtension.class).getApiDocTitle());
            groovydoc.getAccess().convention((Object)GroovydocAccess.PROTECTED);
            groovydoc.getIncludeAuthor().convention((Object)false);
            groovydoc.getProcessScripts().convention((Object)true);
            groovydoc.getIncludeMainForScripts().convention((Object)true);
        });
    }

    private static Provider<JavaLauncher> getJavaLauncher(Project project) {
        JavaPluginExtension extension = GroovyBasePlugin.javaPluginExtension(project);
        JavaToolchainService service = GroovyBasePlugin.extensionOf((ExtensionAware)project, JavaToolchainService.class);
        return service.launcherFor(extension.getToolchain());
    }

    private static JavaPluginExtension javaPluginExtension(Project project) {
        return GroovyBasePlugin.extensionOf((ExtensionAware)project, JavaPluginExtension.class);
    }

    private static <T> T extensionOf(ExtensionAware extensionAware, Class<T> type) {
        return (T)extensionAware.getExtensions().getByType(type);
    }

    private static /* synthetic */ boolean lambda$configureSourceSetDefaults$11f1eb8f$1(FileCollection groovySourceFiles, FileTreeElement element) {
        return groovySourceFiles.contains(element.getFile());
    }
}

