/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.InlineFunctionUseSiteChecker;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0014\u0010\u0017\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0013*\u00020\u001bH\u0002\u001a \u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a&\u0010\u001f\u001a\u00020\u00012\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010%\u001a\u00020\u0001*\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010(\u001a\u00020\u0001*\u00020\u00032\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010+\u001a\u00020\u0001*\u00020\u00032\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"validateVararg", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "varargElementType", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "EXCLUDED_MODULE_NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "getEXCLUDED_MODULE_NAMES", "()Ljava/util/Set;", "visibilityError", "element", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "isVisibleAsInternal", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithVisibility;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "isVisibleAsPrivate", "FQ_NAMES_EXCLUDED_FROM_VISIBILITY_CHECKS", "Lorg/jetbrains/kotlin/name/FqName;", "isExcludedFromVisibilityChecks", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "checkVisibility", "referencedDeclarationSymbol", "reference", "checkFunctionUseSite", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "inlineFunctionUseSiteChecker", "Lorg/jetbrains/kotlin/backend/common/InlineFunctionUseSiteChecker;", "ensureTypeIs", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expectedType", "checkFunctionProperties", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "checkFunctionDispatchReceiver", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nCheckerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckerUtils.kt\norg/jetbrains/kotlin/backend/common/checkers/CheckerUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1#2:231\n11563#3,3:232\n1634#4,3:235\n*S KotlinDebug\n*F\n+ 1 CheckerUtils.kt\norg/jetbrains/kotlin/backend/common/checkers/CheckerUtilsKt\n*L\n79#1:232,3\n133#1:235,3\n*E\n"})
public final class CheckerUtilsKt {
    @NotNull
    private static final Set<Name> EXCLUDED_MODULE_NAMES;
    @NotNull
    private static final Set<FqName> FQ_NAMES_EXCLUDED_FROM_VISIBILITY_CHECKS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void validateVararg(@NotNull IrElement irElement, @NotNull IrType type, @NotNull IrType varargElementType, @NotNull CheckerContext context2) {
        Boolean isCorrectArrayOfPrimitiveOrUnsigned;
        Boolean bl;
        IrType primitiveOrUnsignedElementType;
        IrType irType;
        boolean isCorrectArrayOf;
        Intrinsics.checkNotNullParameter(irElement, "irElement");
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(varargElementType, "varargElementType");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (IrTypePredicatesKt.isArray(type) || IrTypePredicatesKt.isNullableArray(type)) {
            boolean bl2;
            IrTypeArgument it = CollectionsKt.single(((IrSimpleType)type).getArguments());
            boolean bl3 = false;
            IrTypeArgument irTypeArgument = it;
            if (irTypeArgument instanceof IrSimpleType) {
                bl2 = Intrinsics.areEqual(it, varargElementType);
            } else if (irTypeArgument instanceof IrTypeProjection) {
                if (((IrTypeProjection)it).getVariance() == Variance.OUT_VARIANCE && Intrinsics.areEqual(((IrTypeProjection)it).getType(), varargElementType)) {
                    return;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return;
            }
        }
        boolean bl4 = isCorrectArrayOf = false;
        if (isCorrectArrayOf) {
            return;
        }
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(type);
        if (irClassifierSymbol != null) {
            IrClassifierSymbol classifier = irClassifierSymbol;
            boolean bl5 = false;
            irType = context2.getIrBuiltIns().getPrimitiveArrayElementTypes().get(classifier);
            if (irType == null) {
                irType = context2.getIrBuiltIns().getUnsignedArraysElementTypes().get(classifier);
            }
        } else {
            irType = null;
        }
        IrType irType2 = primitiveOrUnsignedElementType = irType;
        if (irType2 != null) {
            IrType it = irType2;
            boolean bl6 = false;
            bl = Intrinsics.areEqual(it, varargElementType);
        } else {
            bl = isCorrectArrayOfPrimitiveOrUnsigned = null;
        }
        if (Intrinsics.areEqual(isCorrectArrayOfPrimitiveOrUnsigned, true)) {
            return;
        }
        context2.error(irElement, "Vararg type=" + RenderIrElementKt.render$default(type, null, 1, null) + " is expected to be an array of its underlying varargElementType=" + RenderIrElementKt.render$default(varargElementType, null, 1, null));
    }

    @NotNull
    public static final Set<Name> getEXCLUDED_MODULE_NAMES() {
        return EXCLUDED_MODULE_NAMES;
    }

    private static final void visibilityError(IrElement element, Visibility visibility, CheckerContext context2) {
        String message2 = "The following element references " + (Intrinsics.areEqual(visibility, Visibilities.Unknown.INSTANCE) ? "a declaration with unknown visibility:" : '\'' + visibility.getName() + "' declaration that is invisible in the current scope:");
        context2.error(element, message2);
    }

    private static final boolean isVisibleAsInternal(IrDeclarationWithVisibility $this$isVisibleAsInternal, IrFile file) {
        IrPackageFragment referencedDeclarationPackageFragment = IrUtilsKt.getPackageFragment($this$isVisibleAsInternal);
        IrModuleFragment module2 = file.getModule();
        if (referencedDeclarationPackageFragment.getSymbol() instanceof DescriptorlessExternalPackageFragmentSymbol) {
            return Intrinsics.areEqual(module2.getName().asString(), "<kotlin>");
        }
        return module2.getDescriptor().shouldSeeInternalsOf(IrPackageFragmentsKt.getModuleDescriptor(referencedDeclarationPackageFragment));
    }

    private static final boolean isVisibleAsPrivate(IrDeclarationWithVisibility $this$isVisibleAsPrivate, IrFile file) {
        IrFile irFile = IrUtilsKt.getFileOrNull($this$isVisibleAsPrivate);
        return Intrinsics.areEqual(file.getFileEntry(), irFile != null ? irFile.getFileEntry() : null);
    }

    private static final boolean isExcludedFromVisibilityChecks(IrSymbol $this$isExcludedFromVisibilityChecks) {
        for (FqName excludedFqName : FQ_NAMES_EXCLUDED_FROM_VISIBILITY_CHECKS) {
            if (AdditionalIrUtilsKt.hasEqualFqName($this$isExcludedFromVisibilityChecks, excludedFqName)) {
                return true;
            }
            IrSymbolOwner owner = $this$isExcludedFromVisibilityChecks.getOwner();
            if (!(owner instanceof IrDeclaration)) continue;
            IrDeclarationParent irDeclarationParent = ((IrDeclaration)owner).getParent();
            Object object = irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
            boolean bl = object != null && (object = object.getSymbol()) != null ? AdditionalIrUtilsKt.hasEqualFqName((IrSymbol)object, excludedFqName) : false;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static final void checkVisibility(@NotNull IrSymbol referencedDeclarationSymbol, @NotNull IrElement reference2, @NotNull CheckerContext context2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(referencedDeclarationSymbol, "referencedDeclarationSymbol");
        Intrinsics.checkNotNullParameter(reference2, "reference");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (CheckerUtilsKt.isExcludedFromVisibilityChecks(referencedDeclarationSymbol)) {
            return;
        }
        if (EXCLUDED_MODULE_NAMES.contains(context2.getFile().getModule().getName())) {
            return;
        }
        IrSymbolOwner irSymbolOwner = referencedDeclarationSymbol.getOwner();
        IrDeclarationWithVisibility irDeclarationWithVisibility = irSymbolOwner instanceof IrDeclarationWithVisibility ? (IrDeclarationWithVisibility)irSymbolOwner : null;
        if (irDeclarationWithVisibility == null) {
            return;
        }
        IrDeclarationWithVisibility referencedDeclaration = irDeclarationWithVisibility;
        IrClass classOfReferenced = IrUtilsKt.getParentClassOrNull(referencedDeclaration);
        Visibility visibility = referencedDeclaration.getVisibility().getDelegate();
        IrClass irClass = classOfReferenced;
        EffectiveVisibility effectiveVisibility = EffectiveVisibilityKt.toEffectiveVisibilityOrNull(visibility, irClass != null ? irClass.getSymbol() : null, true, IrUtilsKt.isPublishedApi(referencedDeclaration));
        EffectiveVisibility effectiveVisibility2 = effectiveVisibility;
        if (effectiveVisibility2 instanceof EffectiveVisibility.Internal || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtected || effectiveVisibility2 instanceof EffectiveVisibility.InternalProtectedBound) {
            bl = CheckerUtilsKt.isVisibleAsInternal(referencedDeclaration, context2.getFile());
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Local || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInClass || effectiveVisibility2 instanceof EffectiveVisibility.PrivateInFile) {
            bl = CheckerUtilsKt.isVisibleAsPrivate(referencedDeclaration, context2.getFile());
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.PackagePrivate || effectiveVisibility2 instanceof EffectiveVisibility.Protected || effectiveVisibility2 instanceof EffectiveVisibility.ProtectedBound || effectiveVisibility2 instanceof EffectiveVisibility.Public) {
            bl = true;
        } else if (effectiveVisibility2 instanceof EffectiveVisibility.Unknown || effectiveVisibility2 == null) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isVisible = bl;
        if (!isVisible) {
            CheckerUtilsKt.visibilityError(reference2, visibility, context2);
        }
    }

    public static final void checkFunctionUseSite(@NotNull IrMemberAccessExpression<IrFunctionSymbol> expression2, @NotNull InlineFunctionUseSiteChecker inlineFunctionUseSiteChecker, @NotNull CheckerContext context2) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(inlineFunctionUseSiteChecker, "inlineFunctionUseSiteChecker");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrFunction function2 = expression2.getSymbol().getOwner();
        if (!function2.isInline() || inlineFunctionUseSiteChecker.isPermitted(expression2)) {
            return;
        }
        StringBuilder $this$checkFunctionUseSite_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$checkFunctionUseSite_u24lambda_u244.append("The following element references ").append(function2.getVisibility()).append(" inline ");
        IrFunction irFunction = function2;
        if (irFunction instanceof IrSimpleFunction) {
            string = AdditionalIrUtilsKt.isAccessor(function2) ? "property accessor" : "function";
        } else if (irFunction instanceof IrConstructor) {
            string = "constructor";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$checkFunctionUseSite_u24lambda_u244.append(string);
        $this$checkFunctionUseSite_u24lambda_u244.append(" ").append(function2.getName().asString());
        String message2 = stringBuilder.toString();
        context2.error(expression2, message2);
    }

    public static final void ensureTypeIs(@NotNull IrExpression $this$ensureTypeIs, @NotNull IrType expectedType, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$ensureTypeIs, "<this>");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!Intrinsics.areEqual($this$ensureTypeIs.getType(), expectedType)) {
            context2.error($this$ensureTypeIs, "unexpected type: expected " + RenderIrElementKt.render$default(expectedType, null, 1, null) + ", got " + RenderIrElementKt.render$default($this$ensureTypeIs.getType(), null, 1, null));
        }
    }

    public static final void checkFunctionProperties(@NotNull IrElement $this$checkFunctionProperties, @NotNull IrFunction function2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$checkFunctionProperties, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (function2 instanceof IrSimpleFunction) {
            IrProperty property2;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)function2).getCorrespondingPropertySymbol();
            IrProperty irProperty = property2 = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property2 != null && !Intrinsics.areEqual(property2.getGetter(), function2) && !Intrinsics.areEqual(property2.getSetter(), function2)) {
                context2.error($this$checkFunctionProperties, "Orphaned property getter/setter " + RenderIrElementKt.render$default(function2, null, 1, null));
            }
        }
    }

    public static final void checkFunctionDispatchReceiver(@NotNull IrElement $this$checkFunctionDispatchReceiver, @NotNull IrFunction function2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$checkFunctionDispatchReceiver, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if ((irValueParameter != null ? irValueParameter.getType() : null) instanceof IrDynamicType) {
            context2.error($this$checkFunctionDispatchReceiver, "Dispatch receivers with 'dynamic' type are not allowed");
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Collection collection;
        Object $this$mapTo$iv;
        String[] stringArray = new String[]{"stdlib", "kotlin", "kotlin", "kotlin-test"};
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (String item$iv : $this$mapTo$iv) {
            void it;
            void var6_8 = item$iv;
            collection = destination$iv;
            boolean bl = false;
            collection.add(Name.special('<' + (String)it + '>'));
        }
        EXCLUDED_MODULE_NAMES = (Set)destination$iv;
        $this$mapTo$iv = new String[]{"kotlin.js.sharedBoxCreate", "kotlin.js.sharedBoxWrite", "kotlin.js.sharedBoxRead", "kotlin.wasm.internal.ClosureBoxBoolean", "kotlin.wasm.internal.ClosureBoxByte", "kotlin.wasm.internal.ClosureBoxShort", "kotlin.wasm.internal.ClosureBoxChar", "kotlin.wasm.internal.ClosureBoxInt", "kotlin.wasm.internal.ClosureBoxLong", "kotlin.wasm.internal.ClosureBoxFloat", "kotlin.wasm.internal.ClosureBoxDouble", "kotlin.wasm.internal.ClosureBoxAny", "kotlin.wasm.internal.wasmTypeId", "kotlin.coroutines.CoroutineImpl", "kotlin.native.internal.KClassImpl", "kotlin.native.internal.KTypeImpl", "kotlin.native.internal.KTypeProjectionList", "kotlin.native.internal.KTypeParameterImpl"};
        $this$mapTo$iv = CollectionsKt.listOf($this$mapTo$iv);
        destination$iv = new HashSet();
        $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            void p0;
            String item$iv;
            Object item$iv2 = iterator2.next();
            item$iv = (String)item$iv2;
            collection = destination$iv;
            boolean bl = false;
            collection.add(new FqName((String)p0));
        }
        FQ_NAMES_EXCLUDED_FROM_VISIBILITY_CHECKS = (Set)var1_1;
    }
}

