# Docker Swarm Experimental Features

This page contains a list of features in the Docker Swarm which are
experimental. Experimental features are **not** ready for production. They are
provided for test and evaluation in your sandbox environments.  

The information below describes each feature and the GitHub pull requests and
issues associated with it. If necessary, links are provided to additional
documentation on an issue.  As an active Docker user and community member,
please feel free to provide any feedback on these features you wish.
## Enable experimental features

To enable experimental feature, use the flag `-experimental` on swarm, for example:

```
$ swarm -experimental manage ...
# or
$ swarm -experimental join ...
```

## Current experimental features

 * *none*

## How to comment on an experimental feature

Each feature's documentation includes a list of proposal pull requests or PRs associated with the feature. If you want to comment on or suggest a change to a feature, please add it to the existing feature PR.  

Issues or problems with a feature? Inquire for help on the `#swarm` IRC channel or in on the [Docker Google group](https://groups.google.com/forum/#!forum/docker-user).  
