// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.0
// 	protoc        v3.19.4
// source: envoy/config/rbac/v3/rbac.proto

package rbacv3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	_ "github.com/envoyproxy/go-control-plane/envoy/annotations"
	v32 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/config/route/v3"
	v31 "github.com/envoyproxy/go-control-plane/envoy/type/matcher/v3"
	v33 "github.com/envoyproxy/go-control-plane/envoy/type/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	v1alpha1 "google.golang.org/genproto/googleapis/api/expr/v1alpha1"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Should we do safe-list or block-list style access control?
type RBAC_Action int32

const (
	// The policies grant access to principals. The rest are denied. This is safe-list style
	// access control. This is the default type.
	RBAC_ALLOW RBAC_Action = 0
	// The policies deny access to principals. The rest are allowed. This is block-list style
	// access control.
	RBAC_DENY RBAC_Action = 1
	// The policies set the `access_log_hint` dynamic metadata key based on if requests match.
	// All requests are allowed.
	RBAC_LOG RBAC_Action = 2
)

// Enum value maps for RBAC_Action.
var (
	RBAC_Action_name = map[int32]string{
		0: "ALLOW",
		1: "DENY",
		2: "LOG",
	}
	RBAC_Action_value = map[string]int32{
		"ALLOW": 0,
		"DENY":  1,
		"LOG":   2,
	}
)

func (x RBAC_Action) Enum() *RBAC_Action {
	p := new(RBAC_Action)
	*p = x
	return p
}

func (x RBAC_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RBAC_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_config_rbac_v3_rbac_proto_enumTypes[0].Descriptor()
}

func (RBAC_Action) Type() protoreflect.EnumType {
	return &file_envoy_config_rbac_v3_rbac_proto_enumTypes[0]
}

func (x RBAC_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RBAC_Action.Descriptor instead.
func (RBAC_Action) EnumDescriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{0, 0}
}

// Role Based Access Control (RBAC) provides service-level and method-level access control for a
// service. Requests are allowed or denied based on the `action` and whether a matching policy is
// found. For instance, if the action is ALLOW and a matching policy is found the request should be
// allowed.
//
// RBAC can also be used to make access logging decisions by communicating with access loggers
// through dynamic metadata. When the action is LOG and at least one policy matches, the
// `access_log_hint` value in the shared key namespace 'envoy.common' is set to `true` indicating
// the request should be logged.
//
// Here is an example of RBAC configuration. It has two policies:
//
// * Service account "cluster.local/ns/default/sa/admin" has full access to the service, and so
//   does "cluster.local/ns/default/sa/superuser".
//
// * Any user can read ("GET") the service at paths with prefix "/products", so long as the
//   destination port is either 80 or 443.
//
//  .. code-block:: yaml
//
//   action: ALLOW
//   policies:
//     "service-admin":
//       permissions:
//         - any: true
//       principals:
//         - authenticated:
//             principal_name:
//               exact: "cluster.local/ns/default/sa/admin"
//         - authenticated:
//             principal_name:
//               exact: "cluster.local/ns/default/sa/superuser"
//     "product-viewer":
//       permissions:
//           - and_rules:
//               rules:
//                 - header:
//                     name: ":method"
//                     string_match:
//                       exact: "GET"
//                 - url_path:
//                     path: { prefix: "/products" }
//                 - or_rules:
//                     rules:
//                       - destination_port: 80
//                       - destination_port: 443
//       principals:
//         - any: true
//
type RBAC struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The action to take if a policy matches. Every action either allows or denies a request,
	// and can also carry out action-specific operations.
	//
	// Actions:
	//
	//  * ALLOW: Allows the request if and only if there is a policy that matches
	//    the request.
	//  * DENY: Allows the request if and only if there are no policies that
	//    match the request.
	//  * LOG: Allows all requests. If at least one policy matches, the dynamic
	//    metadata key `access_log_hint` is set to the value `true` under the shared
	//    key namespace 'envoy.common'. If no policies match, it is set to `false`.
	//    Other actions do not modify this key.
	//
	Action RBAC_Action `protobuf:"varint,1,opt,name=action,proto3,enum=envoy.config.rbac.v3.RBAC_Action" json:"action,omitempty"`
	// Maps from policy name to policy. A match occurs when at least one policy matches the request.
	// The policies are evaluated in lexicographic order of the policy name.
	Policies map[string]*Policy `protobuf:"bytes,2,rep,name=policies,proto3" json:"policies,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RBAC) Reset() {
	*x = RBAC{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RBAC) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RBAC) ProtoMessage() {}

func (x *RBAC) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RBAC.ProtoReflect.Descriptor instead.
func (*RBAC) Descriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{0}
}

func (x *RBAC) GetAction() RBAC_Action {
	if x != nil {
		return x.Action
	}
	return RBAC_ALLOW
}

func (x *RBAC) GetPolicies() map[string]*Policy {
	if x != nil {
		return x.Policies
	}
	return nil
}

// Policy specifies a role and the principals that are assigned/denied the role.
// A policy matches if and only if at least one of its permissions match the
// action taking place AND at least one of its principals match the downstream
// AND the condition is true if specified.
type Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The set of permissions that define a role. Each permission is
	// matched with OR semantics. To match all actions for this policy, a single
	// Permission with the `any` field set to true should be used.
	Permissions []*Permission `protobuf:"bytes,1,rep,name=permissions,proto3" json:"permissions,omitempty"`
	// Required. The set of principals that are assigned/denied the role based on
	// “action”. Each principal is matched with OR semantics. To match all
	// downstreams for this policy, a single Principal with the `any` field set to
	// true should be used.
	Principals []*Principal `protobuf:"bytes,2,rep,name=principals,proto3" json:"principals,omitempty"`
	// An optional symbolic expression specifying an access control
	// :ref:`condition <arch_overview_condition>`. The condition is combined
	// with the permissions and the principals as a clause with AND semantics.
	// Only be used when checked_condition is not used.
	Condition *v1alpha1.Expr `protobuf:"bytes,3,opt,name=condition,proto3" json:"condition,omitempty"`
	// [#not-implemented-hide:]
	// An optional symbolic expression that has been successfully type checked.
	// Only be used when condition is not used.
	CheckedCondition *v1alpha1.CheckedExpr `protobuf:"bytes,4,opt,name=checked_condition,json=checkedCondition,proto3" json:"checked_condition,omitempty"`
}

func (x *Policy) Reset() {
	*x = Policy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{1}
}

func (x *Policy) GetPermissions() []*Permission {
	if x != nil {
		return x.Permissions
	}
	return nil
}

func (x *Policy) GetPrincipals() []*Principal {
	if x != nil {
		return x.Principals
	}
	return nil
}

func (x *Policy) GetCondition() *v1alpha1.Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *Policy) GetCheckedCondition() *v1alpha1.CheckedExpr {
	if x != nil {
		return x.CheckedCondition
	}
	return nil
}

// Permission defines an action (or actions) that a principal can take.
// [#next-free-field: 13]
type Permission struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Rule:
	//	*Permission_AndRules
	//	*Permission_OrRules
	//	*Permission_Any
	//	*Permission_Header
	//	*Permission_UrlPath
	//	*Permission_DestinationIp
	//	*Permission_DestinationPort
	//	*Permission_DestinationPortRange
	//	*Permission_Metadata
	//	*Permission_NotRule
	//	*Permission_RequestedServerName
	//	*Permission_Matcher
	Rule isPermission_Rule `protobuf_oneof:"rule"`
}

func (x *Permission) Reset() {
	*x = Permission{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permission) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permission) ProtoMessage() {}

func (x *Permission) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permission.ProtoReflect.Descriptor instead.
func (*Permission) Descriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{2}
}

func (m *Permission) GetRule() isPermission_Rule {
	if m != nil {
		return m.Rule
	}
	return nil
}

func (x *Permission) GetAndRules() *Permission_Set {
	if x, ok := x.GetRule().(*Permission_AndRules); ok {
		return x.AndRules
	}
	return nil
}

func (x *Permission) GetOrRules() *Permission_Set {
	if x, ok := x.GetRule().(*Permission_OrRules); ok {
		return x.OrRules
	}
	return nil
}

func (x *Permission) GetAny() bool {
	if x, ok := x.GetRule().(*Permission_Any); ok {
		return x.Any
	}
	return false
}

func (x *Permission) GetHeader() *v3.HeaderMatcher {
	if x, ok := x.GetRule().(*Permission_Header); ok {
		return x.Header
	}
	return nil
}

func (x *Permission) GetUrlPath() *v31.PathMatcher {
	if x, ok := x.GetRule().(*Permission_UrlPath); ok {
		return x.UrlPath
	}
	return nil
}

func (x *Permission) GetDestinationIp() *v32.CidrRange {
	if x, ok := x.GetRule().(*Permission_DestinationIp); ok {
		return x.DestinationIp
	}
	return nil
}

func (x *Permission) GetDestinationPort() uint32 {
	if x, ok := x.GetRule().(*Permission_DestinationPort); ok {
		return x.DestinationPort
	}
	return 0
}

func (x *Permission) GetDestinationPortRange() *v33.Int32Range {
	if x, ok := x.GetRule().(*Permission_DestinationPortRange); ok {
		return x.DestinationPortRange
	}
	return nil
}

func (x *Permission) GetMetadata() *v31.MetadataMatcher {
	if x, ok := x.GetRule().(*Permission_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (x *Permission) GetNotRule() *Permission {
	if x, ok := x.GetRule().(*Permission_NotRule); ok {
		return x.NotRule
	}
	return nil
}

func (x *Permission) GetRequestedServerName() *v31.StringMatcher {
	if x, ok := x.GetRule().(*Permission_RequestedServerName); ok {
		return x.RequestedServerName
	}
	return nil
}

func (x *Permission) GetMatcher() *v32.TypedExtensionConfig {
	if x, ok := x.GetRule().(*Permission_Matcher); ok {
		return x.Matcher
	}
	return nil
}

type isPermission_Rule interface {
	isPermission_Rule()
}

type Permission_AndRules struct {
	// A set of rules that all must match in order to define the action.
	AndRules *Permission_Set `protobuf:"bytes,1,opt,name=and_rules,json=andRules,proto3,oneof"`
}

type Permission_OrRules struct {
	// A set of rules where at least one must match in order to define the action.
	OrRules *Permission_Set `protobuf:"bytes,2,opt,name=or_rules,json=orRules,proto3,oneof"`
}

type Permission_Any struct {
	// When any is set, it matches any action.
	Any bool `protobuf:"varint,3,opt,name=any,proto3,oneof"`
}

type Permission_Header struct {
	// A header (or pseudo-header such as :path or :method) on the incoming HTTP request. Only
	// available for HTTP request.
	// Note: the pseudo-header :path includes the query and fragment string. Use the `url_path`
	// field if you want to match the URL path without the query and fragment string.
	Header *v3.HeaderMatcher `protobuf:"bytes,4,opt,name=header,proto3,oneof"`
}

type Permission_UrlPath struct {
	// A URL path on the incoming HTTP request. Only available for HTTP.
	UrlPath *v31.PathMatcher `protobuf:"bytes,10,opt,name=url_path,json=urlPath,proto3,oneof"`
}

type Permission_DestinationIp struct {
	// A CIDR block that describes the destination IP.
	DestinationIp *v32.CidrRange `protobuf:"bytes,5,opt,name=destination_ip,json=destinationIp,proto3,oneof"`
}

type Permission_DestinationPort struct {
	// A port number that describes the destination port connecting to.
	DestinationPort uint32 `protobuf:"varint,6,opt,name=destination_port,json=destinationPort,proto3,oneof"`
}

type Permission_DestinationPortRange struct {
	// A port number range that describes a range of destination ports connecting to.
	DestinationPortRange *v33.Int32Range `protobuf:"bytes,11,opt,name=destination_port_range,json=destinationPortRange,proto3,oneof"`
}

type Permission_Metadata struct {
	// Metadata that describes additional information about the action.
	Metadata *v31.MetadataMatcher `protobuf:"bytes,7,opt,name=metadata,proto3,oneof"`
}

type Permission_NotRule struct {
	// Negates matching the provided permission. For instance, if the value of
	// `not_rule` would match, this permission would not match. Conversely, if
	// the value of `not_rule` would not match, this permission would match.
	NotRule *Permission `protobuf:"bytes,8,opt,name=not_rule,json=notRule,proto3,oneof"`
}

type Permission_RequestedServerName struct {
	// The request server from the client's connection request. This is
	// typically TLS SNI.
	//
	// .. attention::
	//
	//   The behavior of this field may be affected by how Envoy is configured
	//   as explained below.
	//
	//   * If the :ref:`TLS Inspector <config_listener_filters_tls_inspector>`
	//     filter is not added, and if a `FilterChainMatch` is not defined for
	//     the :ref:`server name
	//     <envoy_v3_api_field_config.listener.v3.FilterChainMatch.server_names>`,
	//     a TLS connection's requested SNI server name will be treated as if it
	//     wasn't present.
	//
	//   * A :ref:`listener filter <arch_overview_listener_filters>` may
	//     overwrite a connection's requested server name within Envoy.
	//
	// Please refer to :ref:`this FAQ entry <faq_how_to_setup_sni>` to learn to
	// setup SNI.
	RequestedServerName *v31.StringMatcher `protobuf:"bytes,9,opt,name=requested_server_name,json=requestedServerName,proto3,oneof"`
}

type Permission_Matcher struct {
	// Extension for configuring custom matchers for RBAC.
	// [#extension-category: envoy.rbac.matchers]
	Matcher *v32.TypedExtensionConfig `protobuf:"bytes,12,opt,name=matcher,proto3,oneof"`
}

func (*Permission_AndRules) isPermission_Rule() {}

func (*Permission_OrRules) isPermission_Rule() {}

func (*Permission_Any) isPermission_Rule() {}

func (*Permission_Header) isPermission_Rule() {}

func (*Permission_UrlPath) isPermission_Rule() {}

func (*Permission_DestinationIp) isPermission_Rule() {}

func (*Permission_DestinationPort) isPermission_Rule() {}

func (*Permission_DestinationPortRange) isPermission_Rule() {}

func (*Permission_Metadata) isPermission_Rule() {}

func (*Permission_NotRule) isPermission_Rule() {}

func (*Permission_RequestedServerName) isPermission_Rule() {}

func (*Permission_Matcher) isPermission_Rule() {}

// Principal defines an identity or a group of identities for a downstream
// subject.
// [#next-free-field: 12]
type Principal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Identifier:
	//	*Principal_AndIds
	//	*Principal_OrIds
	//	*Principal_Any
	//	*Principal_Authenticated_
	//	*Principal_SourceIp
	//	*Principal_DirectRemoteIp
	//	*Principal_RemoteIp
	//	*Principal_Header
	//	*Principal_UrlPath
	//	*Principal_Metadata
	//	*Principal_NotId
	Identifier isPrincipal_Identifier `protobuf_oneof:"identifier"`
}

func (x *Principal) Reset() {
	*x = Principal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Principal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Principal) ProtoMessage() {}

func (x *Principal) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Principal.ProtoReflect.Descriptor instead.
func (*Principal) Descriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{3}
}

func (m *Principal) GetIdentifier() isPrincipal_Identifier {
	if m != nil {
		return m.Identifier
	}
	return nil
}

func (x *Principal) GetAndIds() *Principal_Set {
	if x, ok := x.GetIdentifier().(*Principal_AndIds); ok {
		return x.AndIds
	}
	return nil
}

func (x *Principal) GetOrIds() *Principal_Set {
	if x, ok := x.GetIdentifier().(*Principal_OrIds); ok {
		return x.OrIds
	}
	return nil
}

func (x *Principal) GetAny() bool {
	if x, ok := x.GetIdentifier().(*Principal_Any); ok {
		return x.Any
	}
	return false
}

func (x *Principal) GetAuthenticated() *Principal_Authenticated {
	if x, ok := x.GetIdentifier().(*Principal_Authenticated_); ok {
		return x.Authenticated
	}
	return nil
}

// Deprecated: Do not use.
func (x *Principal) GetSourceIp() *v32.CidrRange {
	if x, ok := x.GetIdentifier().(*Principal_SourceIp); ok {
		return x.SourceIp
	}
	return nil
}

func (x *Principal) GetDirectRemoteIp() *v32.CidrRange {
	if x, ok := x.GetIdentifier().(*Principal_DirectRemoteIp); ok {
		return x.DirectRemoteIp
	}
	return nil
}

func (x *Principal) GetRemoteIp() *v32.CidrRange {
	if x, ok := x.GetIdentifier().(*Principal_RemoteIp); ok {
		return x.RemoteIp
	}
	return nil
}

func (x *Principal) GetHeader() *v3.HeaderMatcher {
	if x, ok := x.GetIdentifier().(*Principal_Header); ok {
		return x.Header
	}
	return nil
}

func (x *Principal) GetUrlPath() *v31.PathMatcher {
	if x, ok := x.GetIdentifier().(*Principal_UrlPath); ok {
		return x.UrlPath
	}
	return nil
}

func (x *Principal) GetMetadata() *v31.MetadataMatcher {
	if x, ok := x.GetIdentifier().(*Principal_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (x *Principal) GetNotId() *Principal {
	if x, ok := x.GetIdentifier().(*Principal_NotId); ok {
		return x.NotId
	}
	return nil
}

type isPrincipal_Identifier interface {
	isPrincipal_Identifier()
}

type Principal_AndIds struct {
	// A set of identifiers that all must match in order to define the
	// downstream.
	AndIds *Principal_Set `protobuf:"bytes,1,opt,name=and_ids,json=andIds,proto3,oneof"`
}

type Principal_OrIds struct {
	// A set of identifiers at least one must match in order to define the
	// downstream.
	OrIds *Principal_Set `protobuf:"bytes,2,opt,name=or_ids,json=orIds,proto3,oneof"`
}

type Principal_Any struct {
	// When any is set, it matches any downstream.
	Any bool `protobuf:"varint,3,opt,name=any,proto3,oneof"`
}

type Principal_Authenticated_ struct {
	// Authenticated attributes that identify the downstream.
	Authenticated *Principal_Authenticated `protobuf:"bytes,4,opt,name=authenticated,proto3,oneof"`
}

type Principal_SourceIp struct {
	// A CIDR block that describes the downstream IP.
	// This address will honor proxy protocol, but will not honor XFF.
	//
	// Deprecated: Do not use.
	SourceIp *v32.CidrRange `protobuf:"bytes,5,opt,name=source_ip,json=sourceIp,proto3,oneof"`
}

type Principal_DirectRemoteIp struct {
	// A CIDR block that describes the downstream remote/origin address.
	// Note: This is always the physical peer even if the
	// :ref:`remote_ip <envoy_v3_api_field_config.rbac.v3.Principal.remote_ip>` is
	// inferred from for example the x-forwarder-for header, proxy protocol,
	// etc.
	DirectRemoteIp *v32.CidrRange `protobuf:"bytes,10,opt,name=direct_remote_ip,json=directRemoteIp,proto3,oneof"`
}

type Principal_RemoteIp struct {
	// A CIDR block that describes the downstream remote/origin address.
	// Note: This may not be the physical peer and could be different from the
	// :ref:`direct_remote_ip
	// <envoy_v3_api_field_config.rbac.v3.Principal.direct_remote_ip>`. E.g, if the
	// remote ip is inferred from for example the x-forwarder-for header, proxy
	// protocol, etc.
	RemoteIp *v32.CidrRange `protobuf:"bytes,11,opt,name=remote_ip,json=remoteIp,proto3,oneof"`
}

type Principal_Header struct {
	// A header (or pseudo-header such as :path or :method) on the incoming HTTP
	// request. Only available for HTTP request. Note: the pseudo-header :path
	// includes the query and fragment string. Use the `url_path` field if you
	// want to match the URL path without the query and fragment string.
	Header *v3.HeaderMatcher `protobuf:"bytes,6,opt,name=header,proto3,oneof"`
}

type Principal_UrlPath struct {
	// A URL path on the incoming HTTP request. Only available for HTTP.
	UrlPath *v31.PathMatcher `protobuf:"bytes,9,opt,name=url_path,json=urlPath,proto3,oneof"`
}

type Principal_Metadata struct {
	// Metadata that describes additional information about the principal.
	Metadata *v31.MetadataMatcher `protobuf:"bytes,7,opt,name=metadata,proto3,oneof"`
}

type Principal_NotId struct {
	// Negates matching the provided principal. For instance, if the value of
	// `not_id` would match, this principal would not match. Conversely, if the
	// value of `not_id` would not match, this principal would match.
	NotId *Principal `protobuf:"bytes,8,opt,name=not_id,json=notId,proto3,oneof"`
}

func (*Principal_AndIds) isPrincipal_Identifier() {}

func (*Principal_OrIds) isPrincipal_Identifier() {}

func (*Principal_Any) isPrincipal_Identifier() {}

func (*Principal_Authenticated_) isPrincipal_Identifier() {}

func (*Principal_SourceIp) isPrincipal_Identifier() {}

func (*Principal_DirectRemoteIp) isPrincipal_Identifier() {}

func (*Principal_RemoteIp) isPrincipal_Identifier() {}

func (*Principal_Header) isPrincipal_Identifier() {}

func (*Principal_UrlPath) isPrincipal_Identifier() {}

func (*Principal_Metadata) isPrincipal_Identifier() {}

func (*Principal_NotId) isPrincipal_Identifier() {}

// Action defines the result of allowance or denial when a request matches the matcher.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name indicates the policy name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The action to take if the matcher matches. Every action either allows or denies a request,
	// and can also carry out action-specific operations.
	//
	// Actions:
	//
	//  * ALLOW: If the request gets matched on ALLOW, it is permitted.
	//  * DENY: If the request gets matched on DENY, it is not permitted.
	//  * LOG: If the request gets matched on LOG, it is permitted. Besides, the
	//    dynamic metadata key `access_log_hint` under the shared key namespace
	//    'envoy.common' will be set to the value `true`.
	//  * If the request cannot get matched, it will fallback to DENY.
	//
	// Log behavior:
	//
	//  If the RBAC matcher contains at least one LOG action, the dynamic
	//  metadata key `access_log_hint` will be set based on if the request
	//  get matched on the LOG action.
	//
	Action RBAC_Action `protobuf:"varint,2,opt,name=action,proto3,enum=envoy.config.rbac.v3.RBAC_Action" json:"action,omitempty"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{4}
}

func (x *Action) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Action) GetAction() RBAC_Action {
	if x != nil {
		return x.Action
	}
	return RBAC_ALLOW
}

// Used in the `and_rules` and `or_rules` fields in the `rule` oneof. Depending on the context,
// each are applied with the associated behavior.
type Permission_Set struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Rules []*Permission `protobuf:"bytes,1,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *Permission_Set) Reset() {
	*x = Permission_Set{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Permission_Set) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Permission_Set) ProtoMessage() {}

func (x *Permission_Set) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Permission_Set.ProtoReflect.Descriptor instead.
func (*Permission_Set) Descriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Permission_Set) GetRules() []*Permission {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Used in the `and_ids` and `or_ids` fields in the `identifier` oneof.
// Depending on the context, each are applied with the associated behavior.
type Principal_Set struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Ids []*Principal `protobuf:"bytes,1,rep,name=ids,proto3" json:"ids,omitempty"`
}

func (x *Principal_Set) Reset() {
	*x = Principal_Set{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Principal_Set) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Principal_Set) ProtoMessage() {}

func (x *Principal_Set) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Principal_Set.ProtoReflect.Descriptor instead.
func (*Principal_Set) Descriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Principal_Set) GetIds() []*Principal {
	if x != nil {
		return x.Ids
	}
	return nil
}

// Authentication attributes for a downstream.
type Principal_Authenticated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the principal. If set, The URI SAN or DNS SAN in that order
	// is used from the certificate, otherwise the subject field is used. If
	// unset, it applies to any user that is authenticated.
	PrincipalName *v31.StringMatcher `protobuf:"bytes,2,opt,name=principal_name,json=principalName,proto3" json:"principal_name,omitempty"`
}

func (x *Principal_Authenticated) Reset() {
	*x = Principal_Authenticated{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Principal_Authenticated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Principal_Authenticated) ProtoMessage() {}

func (x *Principal_Authenticated) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_config_rbac_v3_rbac_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Principal_Authenticated.ProtoReflect.Descriptor instead.
func (*Principal_Authenticated) Descriptor() ([]byte, []int) {
	return file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP(), []int{3, 1}
}

func (x *Principal_Authenticated) GetPrincipalName() *v31.StringMatcher {
	if x != nil {
		return x.PrincipalName
	}
	return nil
}

var File_envoy_config_rbac_v3_rbac_proto protoreflect.FileDescriptor

var file_envoy_config_rbac_v3_rbac_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x72,
	0x62, 0x61, 0x63, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x14, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x1a, 0x22, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x61, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72, 0x65, 0x2f, 0x76,
	0x33, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x72, 0x6f, 0x75, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x63,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x24, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2f, 0x76, 0x33, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x61, 0x74,
	0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x74,
	0x79, 0x70, 0x65, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x33, 0x2f, 0x73,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x65, 0x78, 0x70, 0x72, 0x2f,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x75, 0x64, 0x70, 0x61,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64, 0x70, 0x61,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x75, 0x64, 0x70, 0x61, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb6, 0x02, 0x0a, 0x04, 0x52, 0x42, 0x41, 0x43, 0x12, 0x43,
	0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62,
	0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x42, 0x41, 0x43, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x42, 0x41,
	0x43, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x59, 0x0a, 0x0d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x32, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x26, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x09,
	0x0a, 0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x4e,
	0x59, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x47, 0x10, 0x02, 0x3a, 0x20, 0x9a, 0xc5,
	0x88, 0x1e, 0x1b, 0x0a, 0x19, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x42, 0x41, 0x43, 0x22, 0x93,
	0x03, 0x0a, 0x06, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4c, 0x0a, 0x0b, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62,
	0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d,
	0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x49, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x42, 0x08, 0xfa, 0x42,
	0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x73, 0x12, 0x5a, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x45, 0x78, 0x70, 0x72, 0x42, 0x1c, 0xf2, 0x98, 0xfe, 0x8f, 0x05, 0x16, 0x12, 0x14, 0x65,
	0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x70,
	0x0a, 0x11, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x65, 0x78, 0x70, 0x72, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x45, 0x78, 0x70, 0x72,
	0x42, 0x1c, 0xf2, 0x98, 0xfe, 0x8f, 0x05, 0x16, 0x12, 0x14, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x10,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x3a, 0x22, 0x9a, 0xc5, 0x88, 0x1e, 0x1d, 0x0a, 0x1b, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x22, 0xda, 0x07, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x09, 0x61, 0x6e, 0x64, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x08,
	0x61, 0x6e, 0x64, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x41, 0x0a, 0x08, 0x6f, 0x72, 0x5f, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76,
	0x33, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74,
	0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x03, 0x61,
	0x6e, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x6a, 0x02, 0x08,
	0x01, 0x48, 0x00, 0x52, 0x03, 0x61, 0x6e, 0x79, 0x12, 0x3e, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x33,
	0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x08, 0x75, 0x72, 0x6c, 0x5f,
	0x70, 0x61, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x07, 0x75, 0x72, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x48, 0x0a, 0x0e, 0x64, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x70, 0x12, 0x36, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x09, 0xfa,
	0x42, 0x06, 0x2a, 0x04, 0x18, 0xff, 0xff, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x51, 0x0a, 0x16, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x44,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3d, 0x0a, 0x08, 0x6e, 0x6f, 0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x07, 0x6e, 0x6f, 0x74, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x5a, 0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00, 0x52, 0x13, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x46, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x07,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x1a, 0x73, 0x0a, 0x03, 0x53, 0x65, 0x74, 0x12, 0x40,
	0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61,
	0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x3a, 0x2a, 0x9a, 0xc5, 0x88, 0x1e, 0x25, 0x0a, 0x23, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x74, 0x3a, 0x26, 0x9a, 0xc5,
	0x88, 0x1e, 0x21, 0x0a, 0x1f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x0a, 0x04, 0x72, 0x75, 0x6c, 0x65, 0x12, 0x03, 0xf8, 0x42,
	0x01, 0x22, 0x9b, 0x08, 0x0a, 0x09, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12,
	0x3e, 0x0a, 0x07, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x2e, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x06, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x73, 0x12,
	0x3c, 0x0a, 0x06, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72,
	0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x2e, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x05, 0x6f, 0x72, 0x49, 0x64, 0x73, 0x12, 0x1b, 0x0a,
	0x03, 0x61, 0x6e, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x6a,
	0x02, 0x08, 0x01, 0x48, 0x00, 0x52, 0x03, 0x61, 0x6e, 0x79, 0x12, 0x55, 0x0a, 0x0d, 0x61, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70,
	0x61, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x48, 0x00, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x4b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x69, 0x64, 0x72,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x0b, 0x18, 0x01, 0x92, 0xc7, 0x86, 0xd8, 0x04, 0x03, 0x33,
	0x2e, 0x30, 0x48, 0x00, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x12, 0x4b,
	0x0a, 0x10, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f,
	0x69, 0x70, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e,
	0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x70, 0x12, 0x3e, 0x0a, 0x09, 0x72,
	0x65, 0x6d, 0x6f, 0x74, 0x65, 0x5f, 0x69, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x69, 0x64, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x48,
	0x00, 0x52, 0x08, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x49, 0x70, 0x12, 0x3e, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65,
	0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x3f, 0x0a, 0x08, 0x75,
	0x72, 0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x07, 0x75, 0x72, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x12, 0x44, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x38, 0x0a, 0x06, 0x6e, 0x6f, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x05, 0x6e, 0x6f, 0x74, 0x49, 0x64, 0x1a, 0x6d, 0x0a, 0x03,
	0x53, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x03, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x03, 0x69, 0x64, 0x73,
	0x3a, 0x29, 0x9a, 0xc5, 0x88, 0x1e, 0x24, 0x0a, 0x22, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x2e, 0x53, 0x65, 0x74, 0x1a, 0x97, 0x01, 0x0a, 0x0d,
	0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x4b, 0x0a,
	0x0e, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x0d, 0x70, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x3a, 0x33, 0x9a, 0xc5, 0x88, 0x1e,
	0x2e, 0x0a, 0x2c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x4a,
	0x04, 0x08, 0x01, 0x10, 0x02, 0x3a, 0x25, 0x9a, 0xc5, 0x88, 0x1e, 0x20, 0x0a, 0x1e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e,
	0x76, 0x32, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x42, 0x11, 0x0a, 0x0a,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22,
	0x60, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x42,
	0x41, 0x43, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x7d, 0x0a, 0x22, 0x69, 0x6f, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f,
	0x78, 0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x72, 0x62, 0x61, 0x63, 0x2e, 0x76, 0x33, 0x42, 0x09, 0x52, 0x62, 0x61, 0x63, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x42, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2f, 0x67, 0x6f, 0x2d, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x2d, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2f, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x72, 0x62, 0x61, 0x63, 0x2f, 0x76,
	0x33, 0x3b, 0x72, 0x62, 0x61, 0x63, 0x76, 0x33, 0xba, 0x80, 0xc8, 0xd1, 0x06, 0x02, 0x10, 0x02,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_config_rbac_v3_rbac_proto_rawDescOnce sync.Once
	file_envoy_config_rbac_v3_rbac_proto_rawDescData = file_envoy_config_rbac_v3_rbac_proto_rawDesc
)

func file_envoy_config_rbac_v3_rbac_proto_rawDescGZIP() []byte {
	file_envoy_config_rbac_v3_rbac_proto_rawDescOnce.Do(func() {
		file_envoy_config_rbac_v3_rbac_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_config_rbac_v3_rbac_proto_rawDescData)
	})
	return file_envoy_config_rbac_v3_rbac_proto_rawDescData
}

var file_envoy_config_rbac_v3_rbac_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_envoy_config_rbac_v3_rbac_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_envoy_config_rbac_v3_rbac_proto_goTypes = []interface{}{
	(RBAC_Action)(0),                 // 0: envoy.config.rbac.v3.RBAC.Action
	(*RBAC)(nil),                     // 1: envoy.config.rbac.v3.RBAC
	(*Policy)(nil),                   // 2: envoy.config.rbac.v3.Policy
	(*Permission)(nil),               // 3: envoy.config.rbac.v3.Permission
	(*Principal)(nil),                // 4: envoy.config.rbac.v3.Principal
	(*Action)(nil),                   // 5: envoy.config.rbac.v3.Action
	nil,                              // 6: envoy.config.rbac.v3.RBAC.PoliciesEntry
	(*Permission_Set)(nil),           // 7: envoy.config.rbac.v3.Permission.Set
	(*Principal_Set)(nil),            // 8: envoy.config.rbac.v3.Principal.Set
	(*Principal_Authenticated)(nil),  // 9: envoy.config.rbac.v3.Principal.Authenticated
	(*v1alpha1.Expr)(nil),            // 10: google.api.expr.v1alpha1.Expr
	(*v1alpha1.CheckedExpr)(nil),     // 11: google.api.expr.v1alpha1.CheckedExpr
	(*v3.HeaderMatcher)(nil),         // 12: envoy.config.route.v3.HeaderMatcher
	(*v31.PathMatcher)(nil),          // 13: envoy.type.matcher.v3.PathMatcher
	(*v32.CidrRange)(nil),            // 14: envoy.config.core.v3.CidrRange
	(*v33.Int32Range)(nil),           // 15: envoy.type.v3.Int32Range
	(*v31.MetadataMatcher)(nil),      // 16: envoy.type.matcher.v3.MetadataMatcher
	(*v31.StringMatcher)(nil),        // 17: envoy.type.matcher.v3.StringMatcher
	(*v32.TypedExtensionConfig)(nil), // 18: envoy.config.core.v3.TypedExtensionConfig
}
var file_envoy_config_rbac_v3_rbac_proto_depIdxs = []int32{
	0,  // 0: envoy.config.rbac.v3.RBAC.action:type_name -> envoy.config.rbac.v3.RBAC.Action
	6,  // 1: envoy.config.rbac.v3.RBAC.policies:type_name -> envoy.config.rbac.v3.RBAC.PoliciesEntry
	3,  // 2: envoy.config.rbac.v3.Policy.permissions:type_name -> envoy.config.rbac.v3.Permission
	4,  // 3: envoy.config.rbac.v3.Policy.principals:type_name -> envoy.config.rbac.v3.Principal
	10, // 4: envoy.config.rbac.v3.Policy.condition:type_name -> google.api.expr.v1alpha1.Expr
	11, // 5: envoy.config.rbac.v3.Policy.checked_condition:type_name -> google.api.expr.v1alpha1.CheckedExpr
	7,  // 6: envoy.config.rbac.v3.Permission.and_rules:type_name -> envoy.config.rbac.v3.Permission.Set
	7,  // 7: envoy.config.rbac.v3.Permission.or_rules:type_name -> envoy.config.rbac.v3.Permission.Set
	12, // 8: envoy.config.rbac.v3.Permission.header:type_name -> envoy.config.route.v3.HeaderMatcher
	13, // 9: envoy.config.rbac.v3.Permission.url_path:type_name -> envoy.type.matcher.v3.PathMatcher
	14, // 10: envoy.config.rbac.v3.Permission.destination_ip:type_name -> envoy.config.core.v3.CidrRange
	15, // 11: envoy.config.rbac.v3.Permission.destination_port_range:type_name -> envoy.type.v3.Int32Range
	16, // 12: envoy.config.rbac.v3.Permission.metadata:type_name -> envoy.type.matcher.v3.MetadataMatcher
	3,  // 13: envoy.config.rbac.v3.Permission.not_rule:type_name -> envoy.config.rbac.v3.Permission
	17, // 14: envoy.config.rbac.v3.Permission.requested_server_name:type_name -> envoy.type.matcher.v3.StringMatcher
	18, // 15: envoy.config.rbac.v3.Permission.matcher:type_name -> envoy.config.core.v3.TypedExtensionConfig
	8,  // 16: envoy.config.rbac.v3.Principal.and_ids:type_name -> envoy.config.rbac.v3.Principal.Set
	8,  // 17: envoy.config.rbac.v3.Principal.or_ids:type_name -> envoy.config.rbac.v3.Principal.Set
	9,  // 18: envoy.config.rbac.v3.Principal.authenticated:type_name -> envoy.config.rbac.v3.Principal.Authenticated
	14, // 19: envoy.config.rbac.v3.Principal.source_ip:type_name -> envoy.config.core.v3.CidrRange
	14, // 20: envoy.config.rbac.v3.Principal.direct_remote_ip:type_name -> envoy.config.core.v3.CidrRange
	14, // 21: envoy.config.rbac.v3.Principal.remote_ip:type_name -> envoy.config.core.v3.CidrRange
	12, // 22: envoy.config.rbac.v3.Principal.header:type_name -> envoy.config.route.v3.HeaderMatcher
	13, // 23: envoy.config.rbac.v3.Principal.url_path:type_name -> envoy.type.matcher.v3.PathMatcher
	16, // 24: envoy.config.rbac.v3.Principal.metadata:type_name -> envoy.type.matcher.v3.MetadataMatcher
	4,  // 25: envoy.config.rbac.v3.Principal.not_id:type_name -> envoy.config.rbac.v3.Principal
	0,  // 26: envoy.config.rbac.v3.Action.action:type_name -> envoy.config.rbac.v3.RBAC.Action
	2,  // 27: envoy.config.rbac.v3.RBAC.PoliciesEntry.value:type_name -> envoy.config.rbac.v3.Policy
	3,  // 28: envoy.config.rbac.v3.Permission.Set.rules:type_name -> envoy.config.rbac.v3.Permission
	4,  // 29: envoy.config.rbac.v3.Principal.Set.ids:type_name -> envoy.config.rbac.v3.Principal
	17, // 30: envoy.config.rbac.v3.Principal.Authenticated.principal_name:type_name -> envoy.type.matcher.v3.StringMatcher
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_envoy_config_rbac_v3_rbac_proto_init() }
func file_envoy_config_rbac_v3_rbac_proto_init() {
	if File_envoy_config_rbac_v3_rbac_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_config_rbac_v3_rbac_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RBAC); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_rbac_v3_rbac_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Policy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_rbac_v3_rbac_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Permission); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_rbac_v3_rbac_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Principal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_rbac_v3_rbac_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_rbac_v3_rbac_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Permission_Set); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_rbac_v3_rbac_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Principal_Set); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_config_rbac_v3_rbac_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Principal_Authenticated); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_config_rbac_v3_rbac_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Permission_AndRules)(nil),
		(*Permission_OrRules)(nil),
		(*Permission_Any)(nil),
		(*Permission_Header)(nil),
		(*Permission_UrlPath)(nil),
		(*Permission_DestinationIp)(nil),
		(*Permission_DestinationPort)(nil),
		(*Permission_DestinationPortRange)(nil),
		(*Permission_Metadata)(nil),
		(*Permission_NotRule)(nil),
		(*Permission_RequestedServerName)(nil),
		(*Permission_Matcher)(nil),
	}
	file_envoy_config_rbac_v3_rbac_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Principal_AndIds)(nil),
		(*Principal_OrIds)(nil),
		(*Principal_Any)(nil),
		(*Principal_Authenticated_)(nil),
		(*Principal_SourceIp)(nil),
		(*Principal_DirectRemoteIp)(nil),
		(*Principal_RemoteIp)(nil),
		(*Principal_Header)(nil),
		(*Principal_UrlPath)(nil),
		(*Principal_Metadata)(nil),
		(*Principal_NotId)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_config_rbac_v3_rbac_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_config_rbac_v3_rbac_proto_goTypes,
		DependencyIndexes: file_envoy_config_rbac_v3_rbac_proto_depIdxs,
		EnumInfos:         file_envoy_config_rbac_v3_rbac_proto_enumTypes,
		MessageInfos:      file_envoy_config_rbac_v3_rbac_proto_msgTypes,
	}.Build()
	File_envoy_config_rbac_v3_rbac_proto = out.File
	file_envoy_config_rbac_v3_rbac_proto_rawDesc = nil
	file_envoy_config_rbac_v3_rbac_proto_goTypes = nil
	file_envoy_config_rbac_v3_rbac_proto_depIdxs = nil
}
