---
name: Bug report
about: Create a report to help us improve

---

**Found a bug? - We would like to help you and smash the bug away.**
1. __Please don't "report" questions as bugs. For these (questions/build instructions/...) please use one of the following means of contact:__
   * We are reachable via:
    * Matrix room : #FreeRDP:matrix.org (main)
    * XMPP channel: #FreeRDP#matrix.org@matrix.org (bridged)
    * IRC channel : #freerdp @ irc.oftc.net (bridged)
   * We are reachable via mailing list <freerdp-devel@lists.sourceforge.net>
   * Try our mailing list for discussions/questions
1. Before reporting a bug have a look into our issue tracker to see if the bug was already reported and you can add some additional information.
1. If it's a __new__ bug - create a new issue.
1. For more details see https://github.com/FreeRDP/FreeRDP/wiki/BugReporting


**Describe the bug**
A clear and concise description of what the bug is.

**To Reproduce**
Steps to reproduce the behavior:
1. Go to '...'
2. Click on '....'
3. Scroll down to '....'
4. See error

**Expected behavior**
A clear and concise description of what you expected to happen.

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Application details**
* FreeRDP version (`xfreerdp /version`)
* Command line used
* Output of `xfreerdp /buildconfig`
* OS version connecting to (server side)
* If available the log output from a run with `/log-level:trace 2>&1 | tee log.txt` 
* If you built it yourself add some notes which tag/commit/branch you have used, also your cmake parameters and
  compiler can help

**Environment (please complete the following information):**
 - OS: [e.g. Linux/Windows/Android/..]
 - Version/Distribution: [e.g. Debian 10, Windows 2008, Android 10]
 - Architecture: [amd64, arm]:

**Additional context**
Add any other context about the problem here.

** Please remove this text before submitting your issue!

_Thank you for reporting a bug!_
