/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline.sqltool;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileRecordReader {
    public static final int INITIAL_CHARBUFFER_SIZE = 10240;
    private URL url;
    private InputStreamReader reader;
    private Pattern recordPattern;
    private long postRead;
    private StringBuilder stringBuffer = new StringBuilder();
    private char[] charBuffer = new char[10240];

    public FileRecordReader(String string, String string2, String string3) throws IOException, UnsupportedEncodingException {
        this(new URL("file", null, string), string2, string3);
    }

    public FileRecordReader(URL uRL, String string, String string2) throws IOException, UnsupportedEncodingException {
        this.url = uRL;
        this.reader = new InputStreamReader(this.url.openStream(), string2);
        this.recordPattern = Pattern.compile("(.*?)(" + string + ").*", 32);
    }

    public void close() throws IOException {
        if (this.reader == null) {
            throw new IllegalStateException("File already closed: " + this.url);
        }
        this.reader.close();
        this.reader = null;
    }

    public String getName() {
        String string = this.url.getPath();
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(92)) > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String toString() {
        return this.url.toString();
    }

    public boolean isOpen() {
        return this.reader != null;
    }

    public static void main(String[] stringArray) throws IOException {
        String string;
        if (stringArray.length != 2) {
            throw new IllegalArgumentException("SYNTAX: java " + FileRecordReader.class.getName() + " file.txt RECORD_DELIM");
        }
        FileRecordReader fileRecordReader = new FileRecordReader(stringArray[0], stringArray[1], "UTF-8");
        int n = 0;
        while ((string = fileRecordReader.nextRecord()) != null) {
            System.out.println("Rec #" + ++n + ":  [" + string + ']');
        }
    }

    public String nextRecord() throws IOException {
        boolean bl = false;
        while (true) {
            Matcher matcher;
            if ((matcher = this.recordPattern.matcher(this.stringBuffer)).matches()) {
                String string = matcher.group(1);
                this.stringBuffer.delete(0, matcher.end(2));
                return string;
            }
            if (this.reader == null) {
                if (this.stringBuffer.length() < 1) {
                    return null;
                }
                String string = this.stringBuffer.toString();
                this.stringBuffer.setLength(0);
                return string;
            }
            this.reload(bl);
            bl = true;
        }
    }

    private void reload(boolean bl) throws IOException {
        int n;
        if (this.reader == null) {
            throw new IllegalStateException("Attempt to reload after source file has been closed");
        }
        if (bl) {
            this.charBuffer = new char[this.charBuffer.length * 2];
        }
        if ((n = this.reader.read(this.charBuffer)) > 0) {
            this.stringBuffer.append(this.charBuffer, 0, n);
        } else {
            this.close();
        }
    }
}

