/***************************************************************************
                          dynlist.h  -  description
                             -------------------
    begin                : Sat Apr 8 2000
    copyright            : (C) 2000 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DYNLIST_H
#define DYNLIST_H

#ifdef __cplusplus
extern "C" {
#endif

//dl flags
#define DL_NONE         (0)
#define DL_AUTODELETE   (1L<<0)
#define DL_NOCALLBACK   (1L<<1)

typedef struct _DL_Entry {
    struct _DL_Entry    *next;
    struct _DL_Entry    *prev;
    void                *data;
} DL_Entry;

typedef struct {
    unsigned int    flags;
    unsigned int    counter; //don't edit
    DL_Entry        head; //don't edit
    DL_Entry        tail; //don't edit
    void            (*cb_destroy)(void*);
} DList;

void DL_Init(DList *dlist);
int  DL_Insert(DList *dlist, unsigned int index, void *item); //insert item
int  DL_Add(DList *dlist, void *item); //insert at the end
int  DL_DeleteEntry(DList *dlist, DL_Entry *e);
int  DL_DeletePtr(DList *dlist, void *item);
int  DL_Delete(DList *dlist, unsigned int index);
void* DL_Get(DList *dlist, int index);
void DL_Clear(DList *dlist); //clear full list

#ifdef __cplusplus
};
#endif

#endif
