/***************************************************************************
                          menuitem.h  -  description
                             -------------------
    begin                : Tue Feb 29 2000
    copyright            : (C) 2000 by Michael Speck
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MENUITEM_H
#define MENUITEM_H


/**
  *@author Michael Speck
  */

#include "sdl.h"
class Menu;

//manager return values
#define MR_NONE		0
#define MR_CONTINUE	1
//entry types
#define ET_SEPARATOR	0
#define ET_SUBMENU		1
#define ET_SWITCHGRP    2
#define ET_RANGE		3
#define ET_ACTION		4
#define ET_KEY			5
#define ET_STRING		6
class MenuItem {
public: 
    MenuItem();  //Separator
    MenuItem(char *name); //Separator
    MenuItem(char *name, int *p, char *cap1, char *cap2); //switch
    MenuItem(char *name, int *p, char **caps, int num); //switch group
    MenuItem(char *name, int *p, int min, int max, int step = 1); //range
    MenuItem(char *name, int *p, char *keys); //key
    MenuItem(char *name, int a_id); //action
    MenuItem(char *name, Menu* m); //submenu
    MenuItem(char *name, char *p, int max); //string
    ~MenuItem();
    void SetXY(int x, int y);
    void SetBackgnd(SDL_Surface *backgnd);
    void SetSubmenu(Menu *m);
    void SetFont(SFnt *fnt, SFnt *enlgt_fnt);
    void ComputeStr();
    void Enlight(int t);
    int  Type();
    int KeyEvent(int code);
    void SetKey(int code);
    void Update();
    void SetChanged(int c);
    void Hide();
    void Refresh();
    void ComputeSize();
    void Compute();
    Menu* Submenu();
    int ActionId();
    void ClearAlpha();
    int Pos();
    void StrUpdate();
    void EditStr(int code, int unicode);
    void SetRestrKeys(char *rk);
    void NoBackgnd();
    int OnItem(int mx, int my);
    int ButtonEvent(SDL_MouseButtonEvent button);
    void SetString(char *s, int rep);
    void SetRange(int ll, int ul, int st, int rep);
    int Used();
    void SetUsed(int u);
private:
    SDL_Surface	*backgnd;
    SFnt    *font;
    SFnt    *enlgt_font;
    char    name[32];
    char    string[64];
    char    **sw_cap;
    int     sw_cap_num;
    int	    type;
    int	    *pos;
    int	    min;
    int	    max;
    int	    action;
    Menu    *submenu;
    char    *restr_keys;
    int	    x;
    int	    y;
    int	    dx;
    int     dy;
    int	    dw;
    int	    dh;
    char    enlighted;
    int     alpha;
    char    changed;
    int     step;
    int     used;
};

#endif
