/*-------------------------------------------------------------------------- 
  Filename        : sgcommon.h
  Abstract        : Common subroutine definitions for SCSI Generic Utilities
  Operation System: Linux 2.2 or greater
  Copyright (c) Intel Corporation 2002
  Author:  	  Andy Cress 

  ----------- Change History -----------------------------------------------
  07/26/02  ARCress  created 
  05/11/05  ARCress  added MAX_SG_DEVS and MAX_DEVLIST_DEVS
----------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------
Copyright (c) 2002, Intel Corporation
All rights reserved.
Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions are met:
  a.. Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer. 
  b.. Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation 
      and/or other materials provided with the distribution. 
  c.. Neither the name of Intel Corporation nor the names of its contributors 
      may be used to endorse or promote products derived from this software 
      without specific prior written permission. 
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR 
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON 
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  -------------------------------------------------------------------------*/

typedef struct {
    uchar chn;
    uchar bus;
    uchar tgt;		  /* SCSI target ID */
    uchar lun;
    uchar devtype;        /* device type: 0=disk, 3=proc */   
    uchar dstatus;	  /* device status =3 means online */
    ulong dcap;     	  /* disk capacity */
    int   maj;            /* device major number */
    int   min;            /* device major number */
    int   sts;   	  /* inquiry status ret */
    int   sgfd;		  /* fd if open */
    uchar fdoit;	  /* if fdoit == 1, ok to send command */
    uchar inq[50];	  /* inquiry buf, max 48 bytes */
    uchar fname[64];	  /* store sg fname */
    uchar sdname[64];     /* store sd device filename */
    uchar srev[8];        /* servo rev, used in sgdskfl.c */
} DEVLIST_TYPE;

/* extended structure used by sgraidmon & sgdiskmon */
typedef struct {
    uchar chn;
    uchar bus;
    uchar tgt;		  /* SCSI target ID */
    uchar lun;
    uchar devtype;        /* device type: 0=disk, 3=proc */   
    uchar dstatus;	  /* device status =3 means online */
    ulong dcap;     	  /* disk capacity */
    int   ret;   	  /* inquiry status ret */
    int   sgfd;		  /* fd if open */
    int   maj;            /* device major number */
    int   min;            /* device major number */
    uchar fdoit;	  /* if fdoit == 1, ok to send command */
    uchar inq[50];	  /* inquiry buf, max 48 bytes */
    uchar fname[64];	  /* store sg fname */
    uchar sdname[64];     /* store sd device filename */
    uchar vendor[9];
    uchar model[17];
    uchar fwrev[5];
    uchar sernum[13];
    uchar other[11];
    uchar fses;        /* =1 if SES enabled device */
    int mdactive; /* 0=active in raid, 1=failed, -1=missing*/
    int mdtab;    /* 0=in the raidtab */
} DEVLISTX_TYPE;

struct SCSI_INQUIRY {
    uchar dev_type;
    uchar rmb_dtq;
    uchar version;
    uchar rdf;
    uchar len;
    uchar rsvd1;
    uchar rsvd2;
    uchar dev_att;
    uchar vendorid[8];
    uchar productid[16];
    uchar productrev[4];
    uchar serialnum[12];	/* default 8, fujitsu = 12 */
};

typedef struct {
       int host;
       int bus;
       int target;
       int lun;
       int all_leaves_searched;
} DEVFS_LIST;

#define  MAX_SG_DEVS    32768  /* see SG_MAX_DEVS in sg.c */
#define  MAX_DEVLIST_DEVS 128  /* num DEVLIST_TYPE entries */ 
#define  MSG_LEN   132
#define DEVT_PROC  3
#define DEVT_EMUL 10
#define DEVT_ENCL 13
#define DEVT_MAX  13
#define DEVT_UNKN 14

void closefd(void);
void closelog(void);
void closeall(void);
void quit(int rc);
void itoh(uchar * chp, int len, char *str);
int findmatch(char *buffer, int sbuf, 
		char *pattern, int spattern, char figncase);
uchar get_ndev(int first);
uchar get_idev(void);
uchar get_mdev(char *model);
uchar get_nextdev(void);
char get_func(void);
void do_pause(void);
void showit(char *buf);
void dumpbufr(FILE * fdout, uchar * bufp, int mlen, char *hdr);
void dump_buf(FILE * fdout, uchar * bufp, int mlen, char *hdr, char fascii);
void dump_log(uchar * bufp, int mlen, char *hdr, char fascii);
void make_dev_name(char *fname, int k, int fnumeric, DEVFS_LIST *devfsnums);
int get_ival(char *valstr, char fhex);
int get_scsi_info(int sgfd, int idx, char *fname, int fservo);
void showmsg(const char * format, ...);
void showlog(const char * format, ...);

