/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.synchro;

import java.io.IOException;
import java.util.Map;
import net.sf.mpxj.synchro.StreamReader;
import net.sf.mpxj.synchro.Synchro;
import net.sf.mpxj.synchro.TableReader;

class UserFieldReader
extends TableReader {
    public UserFieldReader(StreamReader stream) {
        super(stream);
    }

    @Override
    protected void readRow(StreamReader stream, Map<String, Object> map) throws IOException {
        if (stream.getVersion().atLeast(Synchro.VERSION_6_2_0)) {
            this.readVersion62Row(stream, map);
        } else if (stream.getVersion().atLeast(Synchro.VERSION_6_0_0)) {
            this.readVersion60Row(stream, map);
        } else {
            this.readVersion50Row(stream, map);
        }
    }

    @Override
    protected boolean hasUUID() {
        return false;
    }

    @Override
    protected int rowMagicNumber() {
        return 1141537699;
    }

    private void readVersion62Row(StreamReader stream, Map<String, Object> map) throws IOException {
        int type = stream.readInt();
        switch (type) {
            case 2: {
                this.readVersion62BooleanRow(stream, map);
                break;
            }
            case 3: {
                this.readVersion62IntegerRow(stream, map);
                break;
            }
            case 4: {
                this.readVersion62NumberRow(stream, map);
                break;
            }
            case 5: {
                this.readVersion62DateRow(stream, map);
                break;
            }
            case 6: {
                this.readVersion62StringRow(stream, map);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected file format");
            }
        }
    }

    private void readVersion62BooleanRow(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("VALUE", stream.readBoolean());
        map.put("UNKNOWN0", stream.readBytes(1));
        map.put("UNKNOWN1", stream.readBytes(26));
    }

    private void readVersion62IntegerRow(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("VALUE", stream.readInteger());
        map.put("UNKNOWN1", stream.readBytes(26));
    }

    private void readVersion62NumberRow(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("VALUE", stream.readDouble());
        map.put("UNKNOWN1", stream.readBytes(26));
    }

    private void readVersion62StringRow(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("VALUE", stream.readString());
        map.put("UNKNOWN1", stream.readBytes(26));
    }

    private void readVersion62DateRow(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("VALUE", stream.readDate());
        map.put("UNKNOWN0", stream.readInteger());
        map.put("UNKNOWN1", stream.readBytes(26));
    }

    private void readVersion60Row(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("VALUE", stream.readString());
        map.put("UNKNOWN1", stream.readBytes(26));
    }

    private void readVersion50Row(StreamReader stream, Map<String, Object> map) throws IOException {
        map.put("UNKNOWN1", stream.readBytes(16));
        map.put("VALUE", stream.readString());
        map.put("UNKNOWN2", stream.readBytes(26));
    }
}

