#include <stdlib.h>
#include <string.h>
#include "strdupsub.h"
#ifdef TEST
#include <unistd.h>
#include <errno.h>
#endif

char *
strdupsub (const char *orig, const char *weg, const char *hin, size_t * nl,
	char *(*fn)(const char *,const char *))
{
	const char *p;
	char *w;
	char *z;
	size_t l, lorig, lweg, lhin;
	int count;
	lorig = strlen (orig);
	lweg = strlen (weg);
	lhin = strlen (hin);
	if (!lweg)
		count = 1;
	else
		for (count = 0, p = orig; (w = (*fn) (p, weg)); count++)
			p = w + lweg;
	l = count * (lhin - lweg) + lorig + 1;
	w = z = malloc (l);
	if (!z)
		return 0;
	*nl = l;
	while (lweg) {
		const char *fand;
		if (!(fand = (*fn) (orig, weg))) {
			strcpy (w, orig);
			return z;
		}
		if (fand != orig) {
			memcpy (w, orig, fand - orig);
			w += fand - orig;
		}
		memcpy (w, hin, lhin);
		w += lhin;
		orig = fand + lweg;
	}
	memcpy (w, orig, lorig);
	w += lorig;
	memcpy (w, hin, lhin);
	w[lhin] = 0;
	return z;
}

#ifdef TEST
int 
main (void)
{
	char *x;
	size_t y;
#define W(z) x=z;if (!x) errno=ENOMEM,perror("hack"),_exit(1); \
	write(1,x,y);write(1,"\n",1);free(x);
	W (strsub ("abcdefg1fghijklmn1opqr1", "1", "123", &y))
		W (strsub ("abcdefg123fghijklmn123opqr123", "123", "X", &y));
	W (strsub ("abcdefg1fghijklmn1opqr1", "1", "231", &y));
	W (strsub ("abcdefg1fghijklmn1opqr23", "23", "24", &y));
	W (strsub ("abcdefg1fghijklmn1opqr1", "1", "", &y));
	W (strsub ("abcdefg1fghijklmn1opqr1", "", "1", &y));
	W (strsub ("abcdefg1fghijklmn1opqr1", "", "", &y));
	_exit (0);
}

#endif


