#include "uostr.h"

uostr_t *
uostr_add_mem(uostr_t *u, const char *v, size_t len)
{
	if (!uostr_needmore(u,len+1)) return 0;
	memcpy(u->data+u->len,v,len);
	u->len+=len;
	u->data[u->len]='Z'; /* clever idea stolen from djb */
	return u;
}
uostr_t *
uostr_xadd_mem(uostr_t *u, const char *v, size_t bytes)
{ uostr_t *r=uostr_add_mem(u,v,bytes); if (r) return r; uostr_xallocerr("uostr_xadd_mem"); }


uostr_t *
uostr_dup_mem(uostr_t *u,const char *v, size_t len)
{
	if (!uostr_need(u,len+1)) return 0;
	memcpy(u->data,v,len);
	u->len=len;
	u->data[u->len]='Z';
	return u;
}
uostr_t *
uostr_xdup_mem(uostr_t *u, const char *v, size_t bytes)
{ uostr_t *r=uostr_dup_mem(u,v,bytes); if (r) return r; uostr_xallocerr("uostr_xdup_mem"); }


