/*
 * Copyright (c) 2015-2016,2020 Yubico AB
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef YKCS11_VERSION_H
#define YKCS11_VERSION_H

#ifdef __cplusplus
extern "C"
{
#endif

	/**
	 * YKCS11_VERSION_STRING
	 *
	 * Pre-processor symbol with a string that describe the header file
	 * version number.  Used together with ykneomgr_check_version() to verify
	 * header file and run-time library consistency.
	 */
#define YKCS11_VERSION_STRING "2.7.3"

	/**
	 * YKCS11_VERSION_NUMBER
	 *
	 * Pre-processor symbol with a hexadecimal value describing the header
	 * file version number.  For example, when the header version is 1.2.3
	 * this symbol will have the value 0x01020300.  The last two digits
	 * are only used between public releases, and will otherwise be 00.
	 */
#define YKCS11_VERSION_NUMBER 2.7.3

	/**
	 * YKCS11_VERSION_MAJOR
	 *
	 * Pre-processor symbol with a decimal value that describe the major
	 * level of the header file version number.  For example, when the
	 * header version is 1.2.3 this symbol will be 1.
	 */
#define YKCS11_VERSION_MAJOR 2

	/**
	 * YKCS11_VERSION_MINOR
	 *
	 * Pre-processor symbol with a decimal value that describe the minor
	 * level of the header file version number.  For example, when the
	 * header version is 1.2.3 this symbol will be 2.
	 */
#define YKCS11_VERSION_MINOR 7

	/**
	 * YKCS11_VERSION_PATCH
	 *
	 * Pre-processor symbol with a decimal value that describe the patch
	 * level of the header file version number.  For example, when the
	 * header version is 1.2.3 this symbol will be 3.
	 */
#define YKCS11_VERSION_PATCH 3

    /**
     * _WIN32
     *
     * Pre-processor symbol that describes the Windows system architecture.
     */
/* #undef _WIN32 */

    /**
     * YKCS11_DBG
     *
     * Pre-processor symbol that describes how much debug output to print out.
     * Values are between 0 and 9, where 0 mean that debug output is disabled.
     * Default value is 0
     */
#define YKCS11_DBG 0

    /**
     * HW_TESTS
     *
     * Pre-processor symbol indicating whether tests that require a YubiKEY are
     * enabled or disabled.
     * Default value is disabled
     */
/* #undef HW_TESTS */

#ifdef __cplusplus
}
#endif

#endif
