/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.filter;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class PropertyFilter
extends Filter {
    private Hashtable properties;

    public void setProperties(String props) {
        this.properties = this.parseProperties(props);
    }

    public int decide(LoggingEvent event) {
        Map eventProps = event.getProperties();
        if (eventProps == null) {
            event.setProperties(new Hashtable(this.properties));
        } else {
            Iterator iter = this.properties.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (eventProps.containsKey(key)) continue;
                eventProps.put(key, this.properties.get(key));
            }
        }
        return 0;
    }

    private Hashtable parseProperties(String props) {
        Hashtable<String, String> hashTable = new Hashtable<String, String>();
        StringTokenizer pairs = new StringTokenizer(props, ",");
        while (pairs.hasMoreTokens()) {
            StringTokenizer entry = new StringTokenizer(pairs.nextToken(), "=");
            hashTable.put(entry.nextElement().toString().trim(), entry.nextElement().toString().trim());
        }
        return hashTable;
    }
}

