package containerregistry

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// Action enumerates the values for action.
type Action string

const (
	// Allow ...
	Allow Action = "Allow"
)

// PossibleActionValues returns an array of possible values for the Action const type.
func PossibleActionValues() []Action {
	return []Action{Allow}
}

// BaseImageDependencyType enumerates the values for base image dependency type.
type BaseImageDependencyType string

const (
	// BuildTime ...
	BuildTime BaseImageDependencyType = "BuildTime"
	// RunTime ...
	RunTime BaseImageDependencyType = "RunTime"
)

// PossibleBaseImageDependencyTypeValues returns an array of possible values for the BaseImageDependencyType const type.
func PossibleBaseImageDependencyTypeValues() []BaseImageDependencyType {
	return []BaseImageDependencyType{BuildTime, RunTime}
}

// BaseImageTriggerType enumerates the values for base image trigger type.
type BaseImageTriggerType string

const (
	// All ...
	All BaseImageTriggerType = "All"
	// None ...
	None BaseImageTriggerType = "None"
	// Runtime ...
	Runtime BaseImageTriggerType = "Runtime"
)

// PossibleBaseImageTriggerTypeValues returns an array of possible values for the BaseImageTriggerType const type.
func PossibleBaseImageTriggerTypeValues() []BaseImageTriggerType {
	return []BaseImageTriggerType{All, None, Runtime}
}

// BuildStatus enumerates the values for build status.
type BuildStatus string

const (
	// Canceled ...
	Canceled BuildStatus = "Canceled"
	// Error ...
	Error BuildStatus = "Error"
	// Failed ...
	Failed BuildStatus = "Failed"
	// Queued ...
	Queued BuildStatus = "Queued"
	// Running ...
	Running BuildStatus = "Running"
	// Started ...
	Started BuildStatus = "Started"
	// Succeeded ...
	Succeeded BuildStatus = "Succeeded"
	// Timeout ...
	Timeout BuildStatus = "Timeout"
)

// PossibleBuildStatusValues returns an array of possible values for the BuildStatus const type.
func PossibleBuildStatusValues() []BuildStatus {
	return []BuildStatus{Canceled, Error, Failed, Queued, Running, Started, Succeeded, Timeout}
}

// BuildTaskStatus enumerates the values for build task status.
type BuildTaskStatus string

const (
	// Disabled ...
	Disabled BuildTaskStatus = "Disabled"
	// Enabled ...
	Enabled BuildTaskStatus = "Enabled"
)

// PossibleBuildTaskStatusValues returns an array of possible values for the BuildTaskStatus const type.
func PossibleBuildTaskStatusValues() []BuildTaskStatus {
	return []BuildTaskStatus{Disabled, Enabled}
}

// BuildType enumerates the values for build type.
type BuildType string

const (
	// AutoBuild ...
	AutoBuild BuildType = "AutoBuild"
	// QuickBuild ...
	QuickBuild BuildType = "QuickBuild"
)

// PossibleBuildTypeValues returns an array of possible values for the BuildType const type.
func PossibleBuildTypeValues() []BuildType {
	return []BuildType{AutoBuild, QuickBuild}
}

// DefaultAction enumerates the values for default action.
type DefaultAction string

const (
	// DefaultActionAllow ...
	DefaultActionAllow DefaultAction = "Allow"
	// DefaultActionDeny ...
	DefaultActionDeny DefaultAction = "Deny"
)

// PossibleDefaultActionValues returns an array of possible values for the DefaultAction const type.
func PossibleDefaultActionValues() []DefaultAction {
	return []DefaultAction{DefaultActionAllow, DefaultActionDeny}
}

// ImportMode enumerates the values for import mode.
type ImportMode string

const (
	// Force ...
	Force ImportMode = "Force"
	// NoForce ...
	NoForce ImportMode = "NoForce"
)

// PossibleImportModeValues returns an array of possible values for the ImportMode const type.
func PossibleImportModeValues() []ImportMode {
	return []ImportMode{Force, NoForce}
}

// OsType enumerates the values for os type.
type OsType string

const (
	// Linux ...
	Linux OsType = "Linux"
	// Windows ...
	Windows OsType = "Windows"
)

// PossibleOsTypeValues returns an array of possible values for the OsType const type.
func PossibleOsTypeValues() []OsType {
	return []OsType{Linux, Windows}
}

// PasswordName enumerates the values for password name.
type PasswordName string

const (
	// Password ...
	Password PasswordName = "password"
	// Password2 ...
	Password2 PasswordName = "password2"
)

// PossiblePasswordNameValues returns an array of possible values for the PasswordName const type.
func PossiblePasswordNameValues() []PasswordName {
	return []PasswordName{Password, Password2}
}

// PolicyStatus enumerates the values for policy status.
type PolicyStatus string

const (
	// PolicyStatusDisabled ...
	PolicyStatusDisabled PolicyStatus = "disabled"
	// PolicyStatusEnabled ...
	PolicyStatusEnabled PolicyStatus = "enabled"
)

// PossiblePolicyStatusValues returns an array of possible values for the PolicyStatus const type.
func PossiblePolicyStatusValues() []PolicyStatus {
	return []PolicyStatus{PolicyStatusDisabled, PolicyStatusEnabled}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreating, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// RegistryUsageUnit enumerates the values for registry usage unit.
type RegistryUsageUnit string

const (
	// Bytes ...
	Bytes RegistryUsageUnit = "Bytes"
	// Count ...
	Count RegistryUsageUnit = "Count"
)

// PossibleRegistryUsageUnitValues returns an array of possible values for the RegistryUsageUnit const type.
func PossibleRegistryUsageUnitValues() []RegistryUsageUnit {
	return []RegistryUsageUnit{Bytes, Count}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Basic ...
	Basic SkuName = "Basic"
	// Classic ...
	Classic SkuName = "Classic"
	// Premium ...
	Premium SkuName = "Premium"
	// Standard ...
	Standard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Basic, Classic, Premium, Standard}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// SkuTierBasic ...
	SkuTierBasic SkuTier = "Basic"
	// SkuTierClassic ...
	SkuTierClassic SkuTier = "Classic"
	// SkuTierPremium ...
	SkuTierPremium SkuTier = "Premium"
	// SkuTierStandard ...
	SkuTierStandard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{SkuTierBasic, SkuTierClassic, SkuTierPremium, SkuTierStandard}
}

// SourceControlType enumerates the values for source control type.
type SourceControlType string

const (
	// Github ...
	Github SourceControlType = "Github"
	// VisualStudioTeamService ...
	VisualStudioTeamService SourceControlType = "VisualStudioTeamService"
)

// PossibleSourceControlTypeValues returns an array of possible values for the SourceControlType const type.
func PossibleSourceControlTypeValues() []SourceControlType {
	return []SourceControlType{Github, VisualStudioTeamService}
}

// TokenType enumerates the values for token type.
type TokenType string

const (
	// OAuth ...
	OAuth TokenType = "OAuth"
	// PAT ...
	PAT TokenType = "PAT"
)

// PossibleTokenTypeValues returns an array of possible values for the TokenType const type.
func PossibleTokenTypeValues() []TokenType {
	return []TokenType{OAuth, PAT}
}

// TrustPolicyType enumerates the values for trust policy type.
type TrustPolicyType string

const (
	// Notary ...
	Notary TrustPolicyType = "Notary"
)

// PossibleTrustPolicyTypeValues returns an array of possible values for the TrustPolicyType const type.
func PossibleTrustPolicyTypeValues() []TrustPolicyType {
	return []TrustPolicyType{Notary}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeBuildStepProperties ...
	TypeBuildStepProperties Type = "BuildStepProperties"
	// TypeDocker ...
	TypeDocker Type = "Docker"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeBuildStepProperties, TypeDocker}
}

// TypeBasicBuildStepPropertiesUpdateParameters enumerates the values for type basic build step properties
// update parameters.
type TypeBasicBuildStepPropertiesUpdateParameters string

const (
	// TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters ...
	TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters TypeBasicBuildStepPropertiesUpdateParameters = "BuildStepPropertiesUpdateParameters"
	// TypeBasicBuildStepPropertiesUpdateParametersTypeDocker ...
	TypeBasicBuildStepPropertiesUpdateParametersTypeDocker TypeBasicBuildStepPropertiesUpdateParameters = "Docker"
)

// PossibleTypeBasicBuildStepPropertiesUpdateParametersValues returns an array of possible values for the TypeBasicBuildStepPropertiesUpdateParameters const type.
func PossibleTypeBasicBuildStepPropertiesUpdateParametersValues() []TypeBasicBuildStepPropertiesUpdateParameters {
	return []TypeBasicBuildStepPropertiesUpdateParameters{TypeBasicBuildStepPropertiesUpdateParametersTypeBuildStepPropertiesUpdateParameters, TypeBasicBuildStepPropertiesUpdateParametersTypeDocker}
}

// TypeBasicQueueBuildRequest enumerates the values for type basic queue build request.
type TypeBasicQueueBuildRequest string

const (
	// TypeBuildTask ...
	TypeBuildTask TypeBasicQueueBuildRequest = "BuildTask"
	// TypeQueueBuildRequest ...
	TypeQueueBuildRequest TypeBasicQueueBuildRequest = "QueueBuildRequest"
	// TypeQuickBuild ...
	TypeQuickBuild TypeBasicQueueBuildRequest = "QuickBuild"
)

// PossibleTypeBasicQueueBuildRequestValues returns an array of possible values for the TypeBasicQueueBuildRequest const type.
func PossibleTypeBasicQueueBuildRequestValues() []TypeBasicQueueBuildRequest {
	return []TypeBasicQueueBuildRequest{TypeBuildTask, TypeQueueBuildRequest, TypeQuickBuild}
}

// WebhookAction enumerates the values for webhook action.
type WebhookAction string

const (
	// ChartDelete ...
	ChartDelete WebhookAction = "chart_delete"
	// ChartPush ...
	ChartPush WebhookAction = "chart_push"
	// Delete ...
	Delete WebhookAction = "delete"
	// Push ...
	Push WebhookAction = "push"
	// Quarantine ...
	Quarantine WebhookAction = "quarantine"
)

// PossibleWebhookActionValues returns an array of possible values for the WebhookAction const type.
func PossibleWebhookActionValues() []WebhookAction {
	return []WebhookAction{ChartDelete, ChartPush, Delete, Push, Quarantine}
}

// WebhookStatus enumerates the values for webhook status.
type WebhookStatus string

const (
	// WebhookStatusDisabled ...
	WebhookStatusDisabled WebhookStatus = "disabled"
	// WebhookStatusEnabled ...
	WebhookStatusEnabled WebhookStatus = "enabled"
)

// PossibleWebhookStatusValues returns an array of possible values for the WebhookStatus const type.
func PossibleWebhookStatusValues() []WebhookStatus {
	return []WebhookStatus{WebhookStatusDisabled, WebhookStatusEnabled}
}
