package redhatopenshift

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// AdminUpdating ...
	AdminUpdating ProvisioningState = "AdminUpdating"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{AdminUpdating, Creating, Deleting, Failed, Succeeded, Updating}
}

// Visibility enumerates the values for visibility.
type Visibility string

const (
	// Private ...
	Private Visibility = "Private"
	// Public ...
	Public Visibility = "Public"
)

// PossibleVisibilityValues returns an array of possible values for the Visibility const type.
func PossibleVisibilityValues() []Visibility {
	return []Visibility{Private, Public}
}

// Visibility1 enumerates the values for visibility 1.
type Visibility1 string

const (
	// Visibility1Private ...
	Visibility1Private Visibility1 = "Private"
	// Visibility1Public ...
	Visibility1Public Visibility1 = "Public"
)

// PossibleVisibility1Values returns an array of possible values for the Visibility1 const type.
func PossibleVisibility1Values() []Visibility1 {
	return []Visibility1{Visibility1Private, Visibility1Public}
}

// VMSize enumerates the values for vm size.
type VMSize string

const (
	// StandardD2sV3 ...
	StandardD2sV3 VMSize = "Standard_D2s_v3"
	// StandardD4sV3 ...
	StandardD4sV3 VMSize = "Standard_D4s_v3"
	// StandardD8sV3 ...
	StandardD8sV3 VMSize = "Standard_D8s_v3"
)

// PossibleVMSizeValues returns an array of possible values for the VMSize const type.
func PossibleVMSizeValues() []VMSize {
	return []VMSize{StandardD2sV3, StandardD4sV3, StandardD8sV3}
}

// VMSize1 enumerates the values for vm size 1.
type VMSize1 string

const (
	// VMSize1StandardD2sV3 ...
	VMSize1StandardD2sV3 VMSize1 = "Standard_D2s_v3"
	// VMSize1StandardD4sV3 ...
	VMSize1StandardD4sV3 VMSize1 = "Standard_D4s_v3"
	// VMSize1StandardD8sV3 ...
	VMSize1StandardD8sV3 VMSize1 = "Standard_D8s_v3"
)

// PossibleVMSize1Values returns an array of possible values for the VMSize1 const type.
func PossibleVMSize1Values() []VMSize1 {
	return []VMSize1{VMSize1StandardD2sV3, VMSize1StandardD4sV3, VMSize1StandardD8sV3}
}
