package trafficmanagerapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/trafficmanager/mgmt/2015-11-01/trafficmanager"
	"github.com/Azure/go-autorest/autorest"
)

// EndpointsClientAPI contains the set of methods on the EndpointsClient type.
type EndpointsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, profileName string, endpointType string, endpointName string, parameters trafficmanager.Endpoint) (result trafficmanager.Endpoint, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string, endpointType string, endpointName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string, endpointType string, endpointName string) (result trafficmanager.Endpoint, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, endpointType string, endpointName string, parameters trafficmanager.Endpoint) (result trafficmanager.Endpoint, err error)
}

var _ EndpointsClientAPI = (*trafficmanager.EndpointsClient)(nil)

// ProfilesClientAPI contains the set of methods on the ProfilesClient type.
type ProfilesClientAPI interface {
	CheckTrafficManagerRelativeDNSNameAvailability(ctx context.Context, parameters trafficmanager.CheckTrafficManagerRelativeDNSNameAvailabilityParameters) (result trafficmanager.NameAvailability, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, profileName string, parameters trafficmanager.Profile) (result trafficmanager.Profile, err error)
	Delete(ctx context.Context, resourceGroupName string, profileName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, profileName string) (result trafficmanager.Profile, err error)
	ListAll(ctx context.Context) (result trafficmanager.ProfileListResult, err error)
	ListAllInResourceGroup(ctx context.Context, resourceGroupName string) (result trafficmanager.ProfileListResult, err error)
	Update(ctx context.Context, resourceGroupName string, profileName string, parameters trafficmanager.Profile) (result trafficmanager.Profile, err error)
}

var _ ProfilesClientAPI = (*trafficmanager.ProfilesClient)(nil)
