package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyRankingModel invokes the airec.ModifyRankingModel API synchronously
func (client *Client) ModifyRankingModel(request *ModifyRankingModelRequest) (response *ModifyRankingModelResponse, err error) {
	response = CreateModifyRankingModelResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyRankingModelWithChan invokes the airec.ModifyRankingModel API asynchronously
func (client *Client) ModifyRankingModelWithChan(request *ModifyRankingModelRequest) (<-chan *ModifyRankingModelResponse, <-chan error) {
	responseChan := make(chan *ModifyRankingModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyRankingModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyRankingModelWithCallback invokes the airec.ModifyRankingModel API asynchronously
func (client *Client) ModifyRankingModelWithCallback(request *ModifyRankingModelRequest, callback func(response *ModifyRankingModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyRankingModelResponse
		var err error
		defer close(result)
		response, err = client.ModifyRankingModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyRankingModelRequest is the request struct for api ModifyRankingModel
type ModifyRankingModelRequest struct {
	*requests.RoaRequest
	InstanceId     string `position:"Path" name:"instanceId"`
	RankingModelId string `position:"Path" name:"rankingModelId"`
}

// ModifyRankingModelResponse is the response struct for api ModifyRankingModel
type ModifyRankingModelResponse struct {
	*responses.BaseResponse
	Code      string                     `json:"code" xml:"code"`
	Message   string                     `json:"message" xml:"message"`
	RequestId string                     `json:"requestId" xml:"requestId"`
	Result    ResultInModifyRankingModel `json:"result" xml:"result"`
}

// CreateModifyRankingModelRequest creates a request to invoke ModifyRankingModel API
func CreateModifyRankingModelRequest() (request *ModifyRankingModelRequest) {
	request = &ModifyRankingModelRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ModifyRankingModel", "/v2/openapi/instances/[instanceId]/ranking-models/[rankingModelId]", "airec", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateModifyRankingModelResponse creates a response to parse from ModifyRankingModel response
func CreateModifyRankingModelResponse() (response *ModifyRankingModelResponse) {
	response = &ModifyRankingModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
