package bssopenapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSavingsPlansCoverageDetail invokes the bssopenapi.DescribeSavingsPlansCoverageDetail API synchronously
func (client *Client) DescribeSavingsPlansCoverageDetail(request *DescribeSavingsPlansCoverageDetailRequest) (response *DescribeSavingsPlansCoverageDetailResponse, err error) {
	response = CreateDescribeSavingsPlansCoverageDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSavingsPlansCoverageDetailWithChan invokes the bssopenapi.DescribeSavingsPlansCoverageDetail API asynchronously
func (client *Client) DescribeSavingsPlansCoverageDetailWithChan(request *DescribeSavingsPlansCoverageDetailRequest) (<-chan *DescribeSavingsPlansCoverageDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeSavingsPlansCoverageDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSavingsPlansCoverageDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSavingsPlansCoverageDetailWithCallback invokes the bssopenapi.DescribeSavingsPlansCoverageDetail API asynchronously
func (client *Client) DescribeSavingsPlansCoverageDetailWithCallback(request *DescribeSavingsPlansCoverageDetailRequest, callback func(response *DescribeSavingsPlansCoverageDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSavingsPlansCoverageDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeSavingsPlansCoverageDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSavingsPlansCoverageDetailRequest is the request struct for api DescribeSavingsPlansCoverageDetail
type DescribeSavingsPlansCoverageDetailRequest struct {
	*requests.RpcRequest
	PeriodType  string           `position:"Query" name:"PeriodType"`
	BillOwnerId requests.Integer `position:"Query" name:"BillOwnerId"`
	StartPeriod string           `position:"Query" name:"StartPeriod"`
	EndPeriod   string           `position:"Query" name:"EndPeriod"`
	Token       string           `position:"Query" name:"Token"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
}

// DescribeSavingsPlansCoverageDetailResponse is the response struct for api DescribeSavingsPlansCoverageDetail
type DescribeSavingsPlansCoverageDetailResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeSavingsPlansCoverageDetailRequest creates a request to invoke DescribeSavingsPlansCoverageDetail API
func CreateDescribeSavingsPlansCoverageDetailRequest() (request *DescribeSavingsPlansCoverageDetailRequest) {
	request = &DescribeSavingsPlansCoverageDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("BssOpenApi", "2017-12-14", "DescribeSavingsPlansCoverageDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeSavingsPlansCoverageDetailResponse creates a response to parse from DescribeSavingsPlansCoverageDetail response
func CreateDescribeSavingsPlansCoverageDetailResponse() (response *DescribeSavingsPlansCoverageDetailResponse) {
	response = &DescribeSavingsPlansCoverageDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
