package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindDevice invokes the cdrs.BindDevice API synchronously
func (client *Client) BindDevice(request *BindDeviceRequest) (response *BindDeviceResponse, err error) {
	response = CreateBindDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BindDeviceWithChan invokes the cdrs.BindDevice API asynchronously
func (client *Client) BindDeviceWithChan(request *BindDeviceRequest) (<-chan *BindDeviceResponse, <-chan error) {
	responseChan := make(chan *BindDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindDeviceWithCallback invokes the cdrs.BindDevice API asynchronously
func (client *Client) BindDeviceWithCallback(request *BindDeviceRequest, callback func(response *BindDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindDeviceResponse
		var err error
		defer close(result)
		response, err = client.BindDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindDeviceRequest is the request struct for api BindDevice
type BindDeviceRequest struct {
	*requests.RpcRequest
	CorpId    string               `position:"Body" name:"CorpId"`
	Devices   *[]BindDeviceDevices `position:"Body" name:"Devices"  type:"Repeated"`
	AppName   string               `position:"Body" name:"AppName"`
	NameSpace string               `position:"Body" name:"NameSpace"`
}

// BindDeviceDevices is a repeated param struct in BindDeviceRequest
type BindDeviceDevices struct {
	CorpId   string `name:"CorpId"`
	DeviceId string `name:"DeviceId"`
}

// BindDeviceResponse is the response struct for api BindDevice
type BindDeviceResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	Data      []Datas `json:"Data" xml:"Data"`
}

// CreateBindDeviceRequest creates a request to invoke BindDevice API
func CreateBindDeviceRequest() (request *BindDeviceRequest) {
	request = &BindDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "BindDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateBindDeviceResponse creates a response to parse from BindDevice response
func CreateBindDeviceResponse() (response *BindDeviceResponse) {
	response = &BindDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
