package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLorneTasksMetrics invokes the clickhouse.DescribeLorneTasksMetrics API synchronously
func (client *Client) DescribeLorneTasksMetrics(request *DescribeLorneTasksMetricsRequest) (response *DescribeLorneTasksMetricsResponse, err error) {
	response = CreateDescribeLorneTasksMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLorneTasksMetricsWithChan invokes the clickhouse.DescribeLorneTasksMetrics API asynchronously
func (client *Client) DescribeLorneTasksMetricsWithChan(request *DescribeLorneTasksMetricsRequest) (<-chan *DescribeLorneTasksMetricsResponse, <-chan error) {
	responseChan := make(chan *DescribeLorneTasksMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLorneTasksMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLorneTasksMetricsWithCallback invokes the clickhouse.DescribeLorneTasksMetrics API asynchronously
func (client *Client) DescribeLorneTasksMetricsWithCallback(request *DescribeLorneTasksMetricsRequest, callback func(response *DescribeLorneTasksMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLorneTasksMetricsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLorneTasksMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLorneTasksMetricsRequest is the request struct for api DescribeLorneTasksMetrics
type DescribeLorneTasksMetricsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StartTime            string           `position:"Query" name:"StartTime"`
	MetricName           string           `position:"Query" name:"MetricName"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLorneTasksMetricsResponse is the response struct for api DescribeLorneTasksMetrics
type DescribeLorneTasksMetricsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeLorneTasksMetricsRequest creates a request to invoke DescribeLorneTasksMetrics API
func CreateDescribeLorneTasksMetricsRequest() (request *DescribeLorneTasksMetricsRequest) {
	request = &DescribeLorneTasksMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "DescribeLorneTasksMetrics", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeLorneTasksMetricsResponse creates a response to parse from DescribeLorneTasksMetrics response
func CreateDescribeLorneTasksMetricsResponse() (response *DescribeLorneTasksMetricsResponse) {
	response = &DescribeLorneTasksMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
