package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindAXNPrivacyNumber invokes the cloudcallcenter.BindAXNPrivacyNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/bindaxnprivacynumber.html
func (client *Client) BindAXNPrivacyNumber(request *BindAXNPrivacyNumberRequest) (response *BindAXNPrivacyNumberResponse, err error) {
	response = CreateBindAXNPrivacyNumberResponse()
	err = client.DoAction(request, response)
	return
}

// BindAXNPrivacyNumberWithChan invokes the cloudcallcenter.BindAXNPrivacyNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/bindaxnprivacynumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindAXNPrivacyNumberWithChan(request *BindAXNPrivacyNumberRequest) (<-chan *BindAXNPrivacyNumberResponse, <-chan error) {
	responseChan := make(chan *BindAXNPrivacyNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindAXNPrivacyNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindAXNPrivacyNumberWithCallback invokes the cloudcallcenter.BindAXNPrivacyNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/bindaxnprivacynumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindAXNPrivacyNumberWithCallback(request *BindAXNPrivacyNumberRequest, callback func(response *BindAXNPrivacyNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindAXNPrivacyNumberResponse
		var err error
		defer close(result)
		response, err = client.BindAXNPrivacyNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindAXNPrivacyNumberRequest is the request struct for api BindAXNPrivacyNumber
type BindAXNPrivacyNumberRequest struct {
	*requests.RpcRequest
	PoolName       string `position:"Query" name:"PoolName"`
	PhoneNumber    string `position:"Query" name:"PhoneNumber"`
	TelX           string `position:"Query" name:"TelX"`
	Type           string `position:"Query" name:"Type"`
	AreaCode       string `position:"Query" name:"AreaCode"`
	ProviderId     string `position:"Query" name:"ProviderId"`
	Extra          string `position:"Query" name:"Extra"`
	BizId          string `position:"Query" name:"BizId"`
	PoolId         string `position:"Query" name:"PoolId"`
	RegionNameCity string `position:"Query" name:"RegionNameCity"`
}

// BindAXNPrivacyNumberResponse is the response struct for api BindAXNPrivacyNumber
type BindAXNPrivacyNumberResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateBindAXNPrivacyNumberRequest creates a request to invoke BindAXNPrivacyNumber API
func CreateBindAXNPrivacyNumberRequest() (request *BindAXNPrivacyNumberRequest) {
	request = &BindAXNPrivacyNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "BindAXNPrivacyNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateBindAXNPrivacyNumberResponse creates a response to parse from BindAXNPrivacyNumber response
func CreateBindAXNPrivacyNumberResponse() (response *BindAXNPrivacyNumberResponse) {
	response = &BindAXNPrivacyNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
