package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVnTTSConfig invokes the cloudcallcenter.DescribeVnTTSConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnttsconfig.html
func (client *Client) DescribeVnTTSConfig(request *DescribeVnTTSConfigRequest) (response *DescribeVnTTSConfigResponse, err error) {
	response = CreateDescribeVnTTSConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVnTTSConfigWithChan invokes the cloudcallcenter.DescribeVnTTSConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnttsconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnTTSConfigWithChan(request *DescribeVnTTSConfigRequest) (<-chan *DescribeVnTTSConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeVnTTSConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVnTTSConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVnTTSConfigWithCallback invokes the cloudcallcenter.DescribeVnTTSConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnttsconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnTTSConfigWithCallback(request *DescribeVnTTSConfigRequest, callback func(response *DescribeVnTTSConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVnTTSConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeVnTTSConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVnTTSConfigRequest is the request struct for api DescribeVnTTSConfig
type DescribeVnTTSConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeVnTTSConfigResponse is the response struct for api DescribeVnTTSConfig
type DescribeVnTTSConfigResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Voice      string `json:"Voice" xml:"Voice"`
	SpeechRate int    `json:"SpeechRate" xml:"SpeechRate"`
	Volume     int    `json:"Volume" xml:"Volume"`
}

// CreateDescribeVnTTSConfigRequest creates a request to invoke DescribeVnTTSConfig API
func CreateDescribeVnTTSConfigRequest() (request *DescribeVnTTSConfigRequest) {
	request = &DescribeVnTTSConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DescribeVnTTSConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeVnTTSConfigResponse creates a response to parse from DescribeVnTTSConfig response
func CreateDescribeVnTTSConfigResponse() (response *DescribeVnTTSConfigResponse) {
	response = &DescribeVnTTSConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
