package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNumberGroups invokes the cloudcallcenter.ListNumberGroups API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listnumbergroups.html
func (client *Client) ListNumberGroups(request *ListNumberGroupsRequest) (response *ListNumberGroupsResponse, err error) {
	response = CreateListNumberGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListNumberGroupsWithChan invokes the cloudcallcenter.ListNumberGroups API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listnumbergroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNumberGroupsWithChan(request *ListNumberGroupsRequest) (<-chan *ListNumberGroupsResponse, <-chan error) {
	responseChan := make(chan *ListNumberGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNumberGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNumberGroupsWithCallback invokes the cloudcallcenter.ListNumberGroups API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listnumbergroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNumberGroupsWithCallback(request *ListNumberGroupsRequest, callback func(response *ListNumberGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNumberGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListNumberGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNumberGroupsRequest is the request struct for api ListNumberGroups
type ListNumberGroupsRequest struct {
	*requests.RpcRequest
	Number          string `position:"Query" name:"Number"`
	NumberGroupName string `position:"Query" name:"NumberGroupName"`
	NumberGroupId   string `position:"Query" name:"NumberGroupId"`
}

// ListNumberGroupsResponse is the response struct for api ListNumberGroups
type ListNumberGroupsResponse struct {
	*responses.BaseResponse
	RequestId      string       `json:"RequestId" xml:"RequestId"`
	Success        bool         `json:"Success" xml:"Success"`
	Code           string       `json:"Code" xml:"Code"`
	Message        string       `json:"Message" xml:"Message"`
	HttpStatusCode int          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	NumberGroups   NumberGroups `json:"NumberGroups" xml:"NumberGroups"`
}

// CreateListNumberGroupsRequest creates a request to invoke ListNumberGroups API
func CreateListNumberGroupsRequest() (request *ListNumberGroupsRequest) {
	request = &ListNumberGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListNumberGroups", "", "")
	request.Method = requests.POST
	return
}

// CreateListNumberGroupsResponse creates a response to parse from ListNumberGroups response
func CreateListNumberGroupsResponse() (response *ListNumberGroupsResponse) {
	response = &ListNumberGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
