package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryNumberWithoutGroup invokes the cloudcallcenter.QueryNumberWithoutGroup API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumberwithoutgroup.html
func (client *Client) QueryNumberWithoutGroup(request *QueryNumberWithoutGroupRequest) (response *QueryNumberWithoutGroupResponse, err error) {
	response = CreateQueryNumberWithoutGroupResponse()
	err = client.DoAction(request, response)
	return
}

// QueryNumberWithoutGroupWithChan invokes the cloudcallcenter.QueryNumberWithoutGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumberwithoutgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryNumberWithoutGroupWithChan(request *QueryNumberWithoutGroupRequest) (<-chan *QueryNumberWithoutGroupResponse, <-chan error) {
	responseChan := make(chan *QueryNumberWithoutGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryNumberWithoutGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryNumberWithoutGroupWithCallback invokes the cloudcallcenter.QueryNumberWithoutGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/querynumberwithoutgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryNumberWithoutGroupWithCallback(request *QueryNumberWithoutGroupRequest, callback func(response *QueryNumberWithoutGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryNumberWithoutGroupResponse
		var err error
		defer close(result)
		response, err = client.QueryNumberWithoutGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryNumberWithoutGroupRequest is the request struct for api QueryNumberWithoutGroup
type QueryNumberWithoutGroupRequest struct {
	*requests.RpcRequest
}

// QueryNumberWithoutGroupResponse is the response struct for api QueryNumberWithoutGroup
type QueryNumberWithoutGroupResponse struct {
	*responses.BaseResponse
	RequestId      string                        `json:"RequestId" xml:"RequestId"`
	Success        bool                          `json:"Success" xml:"Success"`
	Code           string                        `json:"Code" xml:"Code"`
	Message        string                        `json:"Message" xml:"Message"`
	HttpStatusCode int                           `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInQueryNumberWithoutGroup `json:"Data" xml:"Data"`
}

// CreateQueryNumberWithoutGroupRequest creates a request to invoke QueryNumberWithoutGroup API
func CreateQueryNumberWithoutGroupRequest() (request *QueryNumberWithoutGroupRequest) {
	request = &QueryNumberWithoutGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "QueryNumberWithoutGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryNumberWithoutGroupResponse creates a response to parse from QueryNumberWithoutGroup response
func CreateQueryNumberWithoutGroupResponse() (response *QueryNumberWithoutGroupResponse) {
	response = &QueryNumberWithoutGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
