package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopGetfiltermac invokes the cloudwf.ShopGetfiltermac API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgetfiltermac.html
func (client *Client) ShopGetfiltermac(request *ShopGetfiltermacRequest) (response *ShopGetfiltermacResponse, err error) {
	response = CreateShopGetfiltermacResponse()
	err = client.DoAction(request, response)
	return
}

// ShopGetfiltermacWithChan invokes the cloudwf.ShopGetfiltermac API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgetfiltermac.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopGetfiltermacWithChan(request *ShopGetfiltermacRequest) (<-chan *ShopGetfiltermacResponse, <-chan error) {
	responseChan := make(chan *ShopGetfiltermacResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopGetfiltermac(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopGetfiltermacWithCallback invokes the cloudwf.ShopGetfiltermac API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopgetfiltermac.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopGetfiltermacWithCallback(request *ShopGetfiltermacRequest, callback func(response *ShopGetfiltermacResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopGetfiltermacResponse
		var err error
		defer close(result)
		response, err = client.ShopGetfiltermac(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopGetfiltermacRequest is the request struct for api ShopGetfiltermac
type ShopGetfiltermacRequest struct {
	*requests.RpcRequest
	Sid requests.Integer `position:"Query" name:"Sid"`
}

// ShopGetfiltermacResponse is the response struct for api ShopGetfiltermac
type ShopGetfiltermacResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopGetfiltermacRequest creates a request to invoke ShopGetfiltermac API
func CreateShopGetfiltermacRequest() (request *ShopGetfiltermacRequest) {
	request = &ShopGetfiltermacRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopGetfiltermac", "cloudwf", "openAPI")
	return
}

// CreateShopGetfiltermacResponse creates a response to parse from ShopGetfiltermac response
func CreateShopGetfiltermacResponse() (response *ShopGetfiltermacResponse) {
	response = &ShopGetfiltermacResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
