package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateImportMigration invokes the dataworks_public.CreateImportMigration API synchronously
func (client *Client) CreateImportMigration(request *CreateImportMigrationRequest) (response *CreateImportMigrationResponse, err error) {
	response = CreateCreateImportMigrationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateImportMigrationWithChan invokes the dataworks_public.CreateImportMigration API asynchronously
func (client *Client) CreateImportMigrationWithChan(request *CreateImportMigrationRequest) (<-chan *CreateImportMigrationResponse, <-chan error) {
	responseChan := make(chan *CreateImportMigrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateImportMigration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateImportMigrationWithCallback invokes the dataworks_public.CreateImportMigration API asynchronously
func (client *Client) CreateImportMigrationWithCallback(request *CreateImportMigrationRequest, callback func(response *CreateImportMigrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateImportMigrationResponse
		var err error
		defer close(result)
		response, err = client.CreateImportMigration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateImportMigrationRequest is the request struct for api CreateImportMigration
type CreateImportMigrationRequest struct {
	*requests.RpcRequest
	Description        string           `position:"Body" name:"Description"`
	CommitRule         string           `position:"Body" name:"CommitRule"`
	WorkspaceMap       string           `position:"Body" name:"WorkspaceMap"`
	CalculateEngineMap string           `position:"Body" name:"CalculateEngineMap"`
	PackageFile        string           `position:"Body" name:"PackageFile"`
	Name               string           `position:"Body" name:"Name"`
	PackageType        string           `position:"Body" name:"PackageType"`
	ProjectId          requests.Integer `position:"Body" name:"ProjectId"`
	ResourceGroupMap   string           `position:"Body" name:"ResourceGroupMap"`
}

// CreateImportMigrationResponse is the response struct for api CreateImportMigration
type CreateImportMigrationResponse struct {
	*responses.BaseResponse
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateCreateImportMigrationRequest creates a request to invoke CreateImportMigration API
func CreateCreateImportMigrationRequest() (request *CreateImportMigrationRequest) {
	request = &CreateImportMigrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateImportMigration", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateImportMigrationResponse creates a response to parse from CreateImportMigration response
func CreateCreateImportMigrationResponse() (response *CreateImportMigrationResponse) {
	response = &CreateImportMigrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
