package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseDomainSlsConfig invokes the ddoscoo.CloseDomainSlsConfig API synchronously
func (client *Client) CloseDomainSlsConfig(request *CloseDomainSlsConfigRequest) (response *CloseDomainSlsConfigResponse, err error) {
	response = CreateCloseDomainSlsConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CloseDomainSlsConfigWithChan invokes the ddoscoo.CloseDomainSlsConfig API asynchronously
func (client *Client) CloseDomainSlsConfigWithChan(request *CloseDomainSlsConfigRequest) (<-chan *CloseDomainSlsConfigResponse, <-chan error) {
	responseChan := make(chan *CloseDomainSlsConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseDomainSlsConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseDomainSlsConfigWithCallback invokes the ddoscoo.CloseDomainSlsConfig API asynchronously
func (client *Client) CloseDomainSlsConfigWithCallback(request *CloseDomainSlsConfigRequest, callback func(response *CloseDomainSlsConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseDomainSlsConfigResponse
		var err error
		defer close(result)
		response, err = client.CloseDomainSlsConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseDomainSlsConfigRequest is the request struct for api CloseDomainSlsConfig
type CloseDomainSlsConfigRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Lang            string `position:"Query" name:"Lang"`
}

// CloseDomainSlsConfigResponse is the response struct for api CloseDomainSlsConfig
type CloseDomainSlsConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCloseDomainSlsConfigRequest creates a request to invoke CloseDomainSlsConfig API
func CreateCloseDomainSlsConfigRequest() (request *CloseDomainSlsConfigRequest) {
	request = &CloseDomainSlsConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "CloseDomainSlsConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateCloseDomainSlsConfigResponse creates a response to parse from CloseDomainSlsConfig response
func CreateCloseDomainSlsConfigResponse() (response *CloseDomainSlsConfigResponse) {
	response = &CloseDomainSlsConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
