package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLayer4Rule invokes the ddoscoo.DeleteLayer4Rule API synchronously
func (client *Client) DeleteLayer4Rule(request *DeleteLayer4RuleRequest) (response *DeleteLayer4RuleResponse, err error) {
	response = CreateDeleteLayer4RuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLayer4RuleWithChan invokes the ddoscoo.DeleteLayer4Rule API asynchronously
func (client *Client) DeleteLayer4RuleWithChan(request *DeleteLayer4RuleRequest) (<-chan *DeleteLayer4RuleResponse, <-chan error) {
	responseChan := make(chan *DeleteLayer4RuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLayer4Rule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLayer4RuleWithCallback invokes the ddoscoo.DeleteLayer4Rule API asynchronously
func (client *Client) DeleteLayer4RuleWithCallback(request *DeleteLayer4RuleRequest, callback func(response *DeleteLayer4RuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLayer4RuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteLayer4Rule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLayer4RuleRequest is the request struct for api DeleteLayer4Rule
type DeleteLayer4RuleRequest struct {
	*requests.RpcRequest
	Listeners string `position:"Query" name:"Listeners"`
	SourceIp  string `position:"Query" name:"SourceIp"`
}

// DeleteLayer4RuleResponse is the response struct for api DeleteLayer4Rule
type DeleteLayer4RuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLayer4RuleRequest creates a request to invoke DeleteLayer4Rule API
func CreateDeleteLayer4RuleRequest() (request *DeleteLayer4RuleRequest) {
	request = &DeleteLayer4RuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "DeleteLayer4Rule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteLayer4RuleResponse creates a response to parse from DeleteLayer4Rule response
func CreateDeleteLayer4RuleResponse() (response *DeleteLayer4RuleResponse) {
	response = &DeleteLayer4RuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
