package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdatePipelines invokes the elasticsearch.UpdatePipelines API synchronously
func (client *Client) UpdatePipelines(request *UpdatePipelinesRequest) (response *UpdatePipelinesResponse, err error) {
	response = CreateUpdatePipelinesResponse()
	err = client.DoAction(request, response)
	return
}

// UpdatePipelinesWithChan invokes the elasticsearch.UpdatePipelines API asynchronously
func (client *Client) UpdatePipelinesWithChan(request *UpdatePipelinesRequest) (<-chan *UpdatePipelinesResponse, <-chan error) {
	responseChan := make(chan *UpdatePipelinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdatePipelines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdatePipelinesWithCallback invokes the elasticsearch.UpdatePipelines API asynchronously
func (client *Client) UpdatePipelinesWithCallback(request *UpdatePipelinesRequest, callback func(response *UpdatePipelinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdatePipelinesResponse
		var err error
		defer close(result)
		response, err = client.UpdatePipelines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdatePipelinesRequest is the request struct for api UpdatePipelines
type UpdatePipelinesRequest struct {
	*requests.RoaRequest
	InstanceId  string           `position:"Path" name:"InstanceId"`
	ClientToken string           `position:"Query" name:"clientToken"`
	Trigger     requests.Boolean `position:"Query" name:"trigger"`
}

// UpdatePipelinesResponse is the response struct for api UpdatePipelines
type UpdatePipelinesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateUpdatePipelinesRequest creates a request to invoke UpdatePipelines API
func CreateUpdatePipelinesRequest() (request *UpdatePipelinesRequest) {
	request = &UpdatePipelinesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdatePipelines", "/openapi/logstashes/[InstanceId]/pipelines", "elasticsearch", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdatePipelinesResponse creates a response to parse from UpdatePipelines response
func CreateUpdatePipelinesResponse() (response *UpdatePipelinesResponse) {
	response = &UpdatePipelinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
