package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizePublicFace invokes the facebody.RecognizePublicFace API synchronously
func (client *Client) RecognizePublicFace(request *RecognizePublicFaceRequest) (response *RecognizePublicFaceResponse, err error) {
	response = CreateRecognizePublicFaceResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizePublicFaceWithChan invokes the facebody.RecognizePublicFace API asynchronously
func (client *Client) RecognizePublicFaceWithChan(request *RecognizePublicFaceRequest) (<-chan *RecognizePublicFaceResponse, <-chan error) {
	responseChan := make(chan *RecognizePublicFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizePublicFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizePublicFaceWithCallback invokes the facebody.RecognizePublicFace API asynchronously
func (client *Client) RecognizePublicFaceWithCallback(request *RecognizePublicFaceRequest, callback func(response *RecognizePublicFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizePublicFaceResponse
		var err error
		defer close(result)
		response, err = client.RecognizePublicFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizePublicFaceRequest is the request struct for api RecognizePublicFace
type RecognizePublicFaceRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean           `position:"Query" name:"FormatResultToJson"`
	OssFile            string                     `position:"Query" name:"OssFile"`
	RequestProxyBy     string                     `position:"Query" name:"RequestProxyBy"`
	Task               *[]RecognizePublicFaceTask `position:"Body" name:"Task"  type:"Repeated"`
}

// RecognizePublicFaceTask is a repeated param struct in RecognizePublicFaceRequest
type RecognizePublicFaceTask struct {
	ImageURL  string `name:"ImageURL"`
	ImageData string `name:"ImageData"`
}

// RecognizePublicFaceResponse is the response struct for api RecognizePublicFace
type RecognizePublicFaceResponse struct {
	*responses.BaseResponse
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Data      DataInRecognizePublicFace `json:"Data" xml:"Data"`
}

// CreateRecognizePublicFaceRequest creates a request to invoke RecognizePublicFace API
func CreateRecognizePublicFaceRequest() (request *RecognizePublicFaceRequest) {
	request = &RecognizePublicFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "RecognizePublicFace", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRecognizePublicFaceResponse creates a response to parse from RecognizePublicFace response
func CreateRecognizePublicFaceResponse() (response *RecognizePublicFaceResponse) {
	response = &RecognizePublicFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
