package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSpeechDeviceDetail invokes the iot.GetSpeechDeviceDetail API synchronously
func (client *Client) GetSpeechDeviceDetail(request *GetSpeechDeviceDetailRequest) (response *GetSpeechDeviceDetailResponse, err error) {
	response = CreateGetSpeechDeviceDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetSpeechDeviceDetailWithChan invokes the iot.GetSpeechDeviceDetail API asynchronously
func (client *Client) GetSpeechDeviceDetailWithChan(request *GetSpeechDeviceDetailRequest) (<-chan *GetSpeechDeviceDetailResponse, <-chan error) {
	responseChan := make(chan *GetSpeechDeviceDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSpeechDeviceDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSpeechDeviceDetailWithCallback invokes the iot.GetSpeechDeviceDetail API asynchronously
func (client *Client) GetSpeechDeviceDetailWithCallback(request *GetSpeechDeviceDetailRequest, callback func(response *GetSpeechDeviceDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSpeechDeviceDetailResponse
		var err error
		defer close(result)
		response, err = client.GetSpeechDeviceDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSpeechDeviceDetailRequest is the request struct for api GetSpeechDeviceDetail
type GetSpeechDeviceDetailRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Body" name:"IotId"`
	IotInstanceId string `position:"Body" name:"IotInstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// GetSpeechDeviceDetailResponse is the response struct for api GetSpeechDeviceDetail
type GetSpeechDeviceDetailResponse struct {
	*responses.BaseResponse
	RequestId    string                      `json:"RequestId" xml:"RequestId"`
	Success      bool                        `json:"Success" xml:"Success"`
	Code         string                      `json:"Code" xml:"Code"`
	ErrorMessage string                      `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInGetSpeechDeviceDetail `json:"Data" xml:"Data"`
}

// CreateGetSpeechDeviceDetailRequest creates a request to invoke GetSpeechDeviceDetail API
func CreateGetSpeechDeviceDetailRequest() (request *GetSpeechDeviceDetailRequest) {
	request = &GetSpeechDeviceDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "GetSpeechDeviceDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSpeechDeviceDetailResponse creates a response to parse from GetSpeechDeviceDetail response
func CreateGetSpeechDeviceDetailResponse() (response *GetSpeechDeviceDetailResponse) {
	response = &GetSpeechDeviceDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
