package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TriggerSceneRule invokes the iot.TriggerSceneRule API synchronously
func (client *Client) TriggerSceneRule(request *TriggerSceneRuleRequest) (response *TriggerSceneRuleResponse, err error) {
	response = CreateTriggerSceneRuleResponse()
	err = client.DoAction(request, response)
	return
}

// TriggerSceneRuleWithChan invokes the iot.TriggerSceneRule API asynchronously
func (client *Client) TriggerSceneRuleWithChan(request *TriggerSceneRuleRequest) (<-chan *TriggerSceneRuleResponse, <-chan error) {
	responseChan := make(chan *TriggerSceneRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TriggerSceneRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TriggerSceneRuleWithCallback invokes the iot.TriggerSceneRule API asynchronously
func (client *Client) TriggerSceneRuleWithCallback(request *TriggerSceneRuleRequest, callback func(response *TriggerSceneRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TriggerSceneRuleResponse
		var err error
		defer close(result)
		response, err = client.TriggerSceneRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TriggerSceneRuleRequest is the request struct for api TriggerSceneRule
type TriggerSceneRuleRequest struct {
	*requests.RpcRequest
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	RuleId        string `position:"Query" name:"RuleId"`
}

// TriggerSceneRuleResponse is the response struct for api TriggerSceneRule
type TriggerSceneRuleResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
}

// CreateTriggerSceneRuleRequest creates a request to invoke TriggerSceneRule API
func CreateTriggerSceneRuleRequest() (request *TriggerSceneRuleRequest) {
	request = &TriggerSceneRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "TriggerSceneRule", "", "")
	request.Method = requests.POST
	return
}

// CreateTriggerSceneRuleResponse creates a response to parse from TriggerSceneRule response
func CreateTriggerSceneRuleResponse() (response *TriggerSceneRuleResponse) {
	response = &TriggerSceneRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
