package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDataDispatchConfig invokes the linkwan.UpdateDataDispatchConfig API synchronously
func (client *Client) UpdateDataDispatchConfig(request *UpdateDataDispatchConfigRequest) (response *UpdateDataDispatchConfigResponse, err error) {
	response = CreateUpdateDataDispatchConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDataDispatchConfigWithChan invokes the linkwan.UpdateDataDispatchConfig API asynchronously
func (client *Client) UpdateDataDispatchConfigWithChan(request *UpdateDataDispatchConfigRequest) (<-chan *UpdateDataDispatchConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateDataDispatchConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDataDispatchConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDataDispatchConfigWithCallback invokes the linkwan.UpdateDataDispatchConfig API asynchronously
func (client *Client) UpdateDataDispatchConfigWithCallback(request *UpdateDataDispatchConfigRequest, callback func(response *UpdateDataDispatchConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDataDispatchConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateDataDispatchConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDataDispatchConfigRequest is the request struct for api UpdateDataDispatchConfig
type UpdateDataDispatchConfigRequest struct {
	*requests.RpcRequest
	UplinkTopic             string           `position:"Query" name:"UplinkTopic"`
	DebugSwitch             requests.Boolean `position:"Query" name:"DebugSwitch"`
	ProductType             string           `position:"Query" name:"ProductType"`
	ProductName             string           `position:"Query" name:"ProductName"`
	DataDispatchDestination string           `position:"Query" name:"DataDispatchDestination"`
	UplinkRegionName        string           `position:"Query" name:"UplinkRegionName"`
	ProductKey              string           `position:"Query" name:"ProductKey"`
	NodeGroupId             string           `position:"Query" name:"NodeGroupId"`
	ApiProduct              string           `position:"Body" name:"ApiProduct"`
	ApiRevision             string           `position:"Body" name:"ApiRevision"`
}

// UpdateDataDispatchConfigResponse is the response struct for api UpdateDataDispatchConfig
type UpdateDataDispatchConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateDataDispatchConfigRequest creates a request to invoke UpdateDataDispatchConfig API
func CreateUpdateDataDispatchConfigRequest() (request *UpdateDataDispatchConfigRequest) {
	request = &UpdateDataDispatchConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "UpdateDataDispatchConfig", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDataDispatchConfigResponse creates a response to parse from UpdateDataDispatchConfig response
func CreateUpdateDataDispatchConfigResponse() (response *UpdateDataDispatchConfigResponse) {
	response = &UpdateDataDispatchConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
