package lubancloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BuyOriginPictures invokes the lubancloud.BuyOriginPictures API synchronously
// api document: https://help.aliyun.com/api/lubancloud/buyoriginpictures.html
func (client *Client) BuyOriginPictures(request *BuyOriginPicturesRequest) (response *BuyOriginPicturesResponse, err error) {
	response = CreateBuyOriginPicturesResponse()
	err = client.DoAction(request, response)
	return
}

// BuyOriginPicturesWithChan invokes the lubancloud.BuyOriginPictures API asynchronously
// api document: https://help.aliyun.com/api/lubancloud/buyoriginpictures.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BuyOriginPicturesWithChan(request *BuyOriginPicturesRequest) (<-chan *BuyOriginPicturesResponse, <-chan error) {
	responseChan := make(chan *BuyOriginPicturesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BuyOriginPictures(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BuyOriginPicturesWithCallback invokes the lubancloud.BuyOriginPictures API asynchronously
// api document: https://help.aliyun.com/api/lubancloud/buyoriginpictures.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BuyOriginPicturesWithCallback(request *BuyOriginPicturesRequest, callback func(response *BuyOriginPicturesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BuyOriginPicturesResponse
		var err error
		defer close(result)
		response, err = client.BuyOriginPictures(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BuyOriginPicturesRequest is the request struct for api BuyOriginPictures
type BuyOriginPicturesRequest struct {
	*requests.RpcRequest
	PictureId *[]string `position:"Query" name:"PictureId"  type:"Repeated"`
}

// BuyOriginPicturesResponse is the response struct for api BuyOriginPictures
type BuyOriginPicturesResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Pictures  []Picture `json:"Pictures" xml:"Pictures"`
}

// CreateBuyOriginPicturesRequest creates a request to invoke BuyOriginPictures API
func CreateBuyOriginPicturesRequest() (request *BuyOriginPicturesRequest) {
	request = &BuyOriginPicturesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lubancloud", "2018-05-09", "BuyOriginPictures", "luban", "openAPI")
	return
}

// CreateBuyOriginPicturesResponse creates a response to parse from BuyOriginPictures response
func CreateBuyOriginPicturesResponse() (response *BuyOriginPicturesResponse) {
	response = &BuyOriginPicturesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
