package market

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// NotifyContractEvent invokes the market.NotifyContractEvent API synchronously
// api document: https://help.aliyun.com/api/market/notifycontractevent.html
func (client *Client) NotifyContractEvent(request *NotifyContractEventRequest) (response *NotifyContractEventResponse, err error) {
	response = CreateNotifyContractEventResponse()
	err = client.DoAction(request, response)
	return
}

// NotifyContractEventWithChan invokes the market.NotifyContractEvent API asynchronously
// api document: https://help.aliyun.com/api/market/notifycontractevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) NotifyContractEventWithChan(request *NotifyContractEventRequest) (<-chan *NotifyContractEventResponse, <-chan error) {
	responseChan := make(chan *NotifyContractEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.NotifyContractEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// NotifyContractEventWithCallback invokes the market.NotifyContractEvent API asynchronously
// api document: https://help.aliyun.com/api/market/notifycontractevent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) NotifyContractEventWithCallback(request *NotifyContractEventRequest, callback func(response *NotifyContractEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *NotifyContractEventResponse
		var err error
		defer close(result)
		response, err = client.NotifyContractEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// NotifyContractEventRequest is the request struct for api NotifyContractEvent
type NotifyContractEventRequest struct {
	*requests.RpcRequest
	EventMessage string `position:"Query" name:"EventMessage"`
	EventType    string `position:"Query" name:"EventType"`
}

// NotifyContractEventResponse is the response struct for api NotifyContractEvent
type NotifyContractEventResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateNotifyContractEventRequest creates a request to invoke NotifyContractEvent API
func CreateNotifyContractEventRequest() (request *NotifyContractEventRequest) {
	request = &NotifyContractEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Market", "2015-11-01", "NotifyContractEvent", "yunmarket", "openAPI")
	return
}

// CreateNotifyContractEventResponse creates a response to parse from NotifyContractEvent response
func CreateNotifyContractEventResponse() (response *NotifyContractEventResponse) {
	response = &NotifyContractEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
