package onsmqtt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteGroupId invokes the onsmqtt.DeleteGroupId API synchronously
func (client *Client) DeleteGroupId(request *DeleteGroupIdRequest) (response *DeleteGroupIdResponse, err error) {
	response = CreateDeleteGroupIdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteGroupIdWithChan invokes the onsmqtt.DeleteGroupId API asynchronously
func (client *Client) DeleteGroupIdWithChan(request *DeleteGroupIdRequest) (<-chan *DeleteGroupIdResponse, <-chan error) {
	responseChan := make(chan *DeleteGroupIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteGroupId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteGroupIdWithCallback invokes the onsmqtt.DeleteGroupId API asynchronously
func (client *Client) DeleteGroupIdWithCallback(request *DeleteGroupIdRequest, callback func(response *DeleteGroupIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteGroupIdResponse
		var err error
		defer close(result)
		response, err = client.DeleteGroupId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteGroupIdRequest is the request struct for api DeleteGroupId
type DeleteGroupIdRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteGroupIdResponse is the response struct for api DeleteGroupId
type DeleteGroupIdResponse struct {
	*responses.BaseResponse
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteGroupIdRequest creates a request to invoke DeleteGroupId API
func CreateDeleteGroupIdRequest() (request *DeleteGroupIdRequest) {
	request = &DeleteGroupIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OnsMqtt", "2020-04-20", "DeleteGroupId", "onsmqtt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteGroupIdResponse creates a response to parse from DeleteGroupId response
func CreateDeleteGroupIdResponse() (response *DeleteGroupIdResponse) {
	response = &DeleteGroupIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
