package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDatabasePartitions invokes the petadata.DescribeDatabasePartitions API synchronously
// api document: https://help.aliyun.com/api/petadata/describedatabasepartitions.html
func (client *Client) DescribeDatabasePartitions(request *DescribeDatabasePartitionsRequest) (response *DescribeDatabasePartitionsResponse, err error) {
	response = CreateDescribeDatabasePartitionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDatabasePartitionsWithChan invokes the petadata.DescribeDatabasePartitions API asynchronously
// api document: https://help.aliyun.com/api/petadata/describedatabasepartitions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDatabasePartitionsWithChan(request *DescribeDatabasePartitionsRequest) (<-chan *DescribeDatabasePartitionsResponse, <-chan error) {
	responseChan := make(chan *DescribeDatabasePartitionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDatabasePartitions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDatabasePartitionsWithCallback invokes the petadata.DescribeDatabasePartitions API asynchronously
// api document: https://help.aliyun.com/api/petadata/describedatabasepartitions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDatabasePartitionsWithCallback(request *DescribeDatabasePartitionsRequest, callback func(response *DescribeDatabasePartitionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDatabasePartitionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDatabasePartitions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDatabasePartitionsRequest is the request struct for api DescribeDatabasePartitions
type DescribeDatabasePartitionsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	DBName               string           `position:"Query" name:"DBName"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeDatabasePartitionsResponse is the response struct for api DescribeDatabasePartitions
type DescribeDatabasePartitionsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	InstanceId string     `json:"InstanceId" xml:"InstanceId"`
	DBName     string     `json:"DBName" xml:"DBName"`
	Partitions Partitions `json:"Partitions" xml:"Partitions"`
}

// CreateDescribeDatabasePartitionsRequest creates a request to invoke DescribeDatabasePartitions API
func CreateDescribeDatabasePartitionsRequest() (request *DescribeDatabasePartitionsRequest) {
	request = &DescribeDatabasePartitionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "DescribeDatabasePartitions", "petadata", "openAPI")
	return
}

// CreateDescribeDatabasePartitionsResponse creates a response to parse from DescribeDatabasePartitions response
func CreateDescribeDatabasePartitionsResponse() (response *DescribeDatabasePartitionsResponse) {
	response = &DescribeDatabasePartitionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
