package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpcEndpointServiceResources invokes the privatelink.ListVpcEndpointServiceResources API synchronously
func (client *Client) ListVpcEndpointServiceResources(request *ListVpcEndpointServiceResourcesRequest) (response *ListVpcEndpointServiceResourcesResponse, err error) {
	response = CreateListVpcEndpointServiceResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpcEndpointServiceResourcesWithChan invokes the privatelink.ListVpcEndpointServiceResources API asynchronously
func (client *Client) ListVpcEndpointServiceResourcesWithChan(request *ListVpcEndpointServiceResourcesRequest) (<-chan *ListVpcEndpointServiceResourcesResponse, <-chan error) {
	responseChan := make(chan *ListVpcEndpointServiceResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpcEndpointServiceResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpcEndpointServiceResourcesWithCallback invokes the privatelink.ListVpcEndpointServiceResources API asynchronously
func (client *Client) ListVpcEndpointServiceResourcesWithCallback(request *ListVpcEndpointServiceResourcesRequest, callback func(response *ListVpcEndpointServiceResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpcEndpointServiceResourcesResponse
		var err error
		defer close(result)
		response, err = client.ListVpcEndpointServiceResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpcEndpointServiceResourcesRequest is the request struct for api ListVpcEndpointServiceResources
type ListVpcEndpointServiceResourcesRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	ZoneId     string           `position:"Query" name:"ZoneId"`
	ServiceId  string           `position:"Query" name:"ServiceId"`
}

// ListVpcEndpointServiceResourcesResponse is the response struct for api ListVpcEndpointServiceResources
type ListVpcEndpointServiceResourcesResponse struct {
	*responses.BaseResponse
	NextToken  string     `json:"NextToken" xml:"NextToken"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	MaxResults string     `json:"MaxResults" xml:"MaxResults"`
	Resources  []Resource `json:"Resources" xml:"Resources"`
}

// CreateListVpcEndpointServiceResourcesRequest creates a request to invoke ListVpcEndpointServiceResources API
func CreateListVpcEndpointServiceResourcesRequest() (request *ListVpcEndpointServiceResourcesRequest) {
	request = &ListVpcEndpointServiceResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "ListVpcEndpointServiceResources", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListVpcEndpointServiceResourcesResponse creates a response to parse from ListVpcEndpointServiceResources response
func CreateListVpcEndpointServiceResourcesResponse() (response *ListVpcEndpointServiceResourcesResponse) {
	response = &ListVpcEndpointServiceResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
