/** VSys:$debug.cc:0.0.3-014$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: debug.cc; File version: 0.0.3-014
 */
/*
 * Ethernet IP packets parser.
 * Thanks to TCPDUMP Group for their code - it was very usefull in
 * learning BPF/PCAP usage
 */

#include <stdio.h>
#include <time.h>
#ifdef WIN32
#include <winsock2.h>
#include "win32/ethernet.h"
#else
#include <sys/types.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include "config.h"
#if defined __OS_SOLARIS_LIKE
#include <sys/ethernet.h>
#else
#include <net/ethernet.h>
#endif
#endif

#include "debug.h"

#if defined __VERBOSE__ || defined __DEBUG__
void print_nf( const nf5_stat * nf ) {
	if( !nf ) return;
	in_addr * tmp;
#define __nf_print( name, val ) { fprintf( stdout, "%s: %x\n", name, nf->val);};
	//__nf_print( "src_addr", saddr);    /* Source IP Address */
	//__nf_print( "dst_addr", daddr);    /* Destination IP Address */
tmp = (in_addr *) &(nf->saddr);
printf( "  src ip: %s\n", inet_ntoa( *tmp ));

tmp = (in_addr *) &(nf->daddr);
printf( "  dst ip: %s\n", inet_ntoa( *tmp ));

	__nf_print( " nexthop", nexthop);    /* Next hop router's IP Address */
	__nf_print( "   iface", iface);          /* Input interface index */
//	__nf_print( "out face", output);         /* Output interface index */

	__nf_print( " packets", d_pkt);           /* Packets sent in Duration */
	fprintf( stdout, "%s: %d\n", " traffic", nf->d_oct);         /* Octets sent in Duration. */
//	__nf_print( "ts_first", ts_first);           /* SysUptime at start of flow */
printf( " ts_last: %s", ctime( (time_t *) &nf->ts_last ));
printf( "ts_first: %s", ctime( (time_t *) &nf->ts_first ));
//	__nf_print( " ts_last", ts_last);            /* and of last packet of flow */

	__nf_print( "src port", sport);        /* TCP/UDP source port number or equivalent */
	__nf_print( "dst port", dport);        /* TCP/UDP destination port number or equivalent */
	//__nf_print( "     pad", pad);
	__nf_print( "tcp flag", tcp_flags);      /* Cumulative OR of tcp flags */
	__nf_print( "protocol", proto);           /* IP protocol, e.g., 6=TCP, 17=UDP, ... */
    __nf_print( "     tos", tos);            /* IP Type-of-Service */
#if 0
	__nf_print( "  src AS", src_as);         /* originating AS of source address */
	__nf_print( "  dst AS", dst_as);         /* originating AS of destination address */
	__nf_print( "src mask", src_mask);       /* source address prefix mask bits */
	__nf_print( "dst mask", dst_mask);       /* destination address prefix mask bits */
#endif
}

#endif//__VERBOSE__
#ifdef __DEBUG__

void print_faces() {
	iff_list * face = faces;
	 if_list * fc;
	if( !face ) {
		printf( "Empty `faces'\n" );
		return;
	}
	while( face->iff_len ) {
		fc = face->iff_if;
		if( !fc ) { face++; continue; }
//			printf( "\tempty\n" );
//		} else 
		printf( "Family `%s':\n", face->iff_name );
		while( fc ) {
			printf( "\tDevice `%s' with ifindex %d;\n", fc->ifl_name, fc->ifl_ind );
			fc = fc->ifl_next;
		}
		face++;
	}
	if( !face->iff_if ) return;
	fc = face->iff_if;
	printf( "Family `%s':\n", face->iff_name );
	while( fc ) {
		printf( "\tDevice `%s' with ifindex %d;\n", fc->ifl_name, fc->ifl_ind );
		fc = fc->ifl_next;
	}
}

void print_mac( u_char * mac, u_char mac_size) {
	int i;
	for(i=0; i<mac_size-1; i++)
		printf( "%02x:", mac[i] );
	printf( "%02x", mac[i] );
}

u_int16_t print_eth( const struct ether_header *eh ) {
	if( !eh ) return 0;
	print_mac( (u_char*) eh->ether_shost, ETHER_ADDR_LEN );
	printf( "->" );
	print_mac( (u_char*) eh->ether_dhost, ETHER_ADDR_LEN );
	switch (ntohs(eh->ether_type)) {
		case ETHERTYPE_PUP :
			(void)printf( "| PUP> " );
			break;
		case ETHERTYPE_IP :
			(void)printf( "|  IP> " );
			break;
		case ETHERTYPE_ARP :
			(void)printf( "| ARP> " );
			break;
		case ETHERTYPE_REVARP :
			(void)printf( "|RARP> " );
			break;
		default:
			(void)printf( "|%04x> ", ntohs(eh->ether_type));
	};
	return ntohs(eh->ether_type);
}

void print_ip( const struct iphdr * ih ) {
	if( !ih ) return;
	in_addr * tmp;
#define __ip_print( name, val ) { fprintf( stdout, "%s: %x\n", name, ih->val);};
	__ip_print( " ihl", ih_l );
	__ip_print( " ver", ih_ver );
	__ip_print( " tos", ih_tos );
	__ip_print( " len", ih_len );
	__ip_print( "  id", ih_id );
	__ip_print( "frag", ih_frag );
	__ip_print( " ttl", ih_ttl );
	__ip_print( "prot", ih_proto );
	__ip_print( " sum", ih_check );
	tmp = (in_addr *) &(ih->ih_saddr);
	printf( " Src: %s\n", inet_ntoa( *tmp ));
	
	tmp = (in_addr *) &(ih->ih_daddr);
	printf( " Dst: %s\n", inet_ntoa( *tmp ));
}

const char * resolve_proto( u_int8_t proto ) {
	switch (proto) {
		case IPPROTO_IP: return "IP";
//		case IPPROTO_HOPOPTS: return "HOPOPTS";
		case IPPROTO_ICMP: return "ICMP";
		case IPPROTO_IGMP: return "IGMP";
		case IPPROTO_IPIP: return "IPIP";
		case IPPROTO_TCP: return "TCP";
		case IPPROTO_EGP: return "EGP";
		case IPPROTO_PUP: return "PUP";
		case IPPROTO_UDP: return "UDP";
		case IPPROTO_IDP: return "IDP";
		case IPPROTO_TP: return "TP";
		case IPPROTO_IPV6: return "IPV6";
		case IPPROTO_ROUTING: return "ROUTING";
		case IPPROTO_FRAGMENT: return "FRAGMENT";
		case IPPROTO_RSVP: return "RSVP";
		case IPPROTO_GRE: return "GRE";
		case IPPROTO_ESP: return "ESP";
		case IPPROTO_AH: return "AH";
		case IPPROTO_ICMPV6: return "ICMPV6";
		case IPPROTO_NONE: return "NONE";
		case IPPROTO_DSTOPTS: return "DSTOPTS";
		case IPPROTO_MTP: return "MTP";
		case IPPROTO_ENCAP: return "ENCAP";
		case IPPROTO_PIM: return "PIM";
//		case IPPROTO_COMP: return "COMP";
		case IPPROTO_RAW: return "RAW";
		default : return "?";
	}
}
#endif//__DEBUG__
